/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class UnitPropertyDescriptorProvider
extends PropertyDescriptorProvider {
    public UnitPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public String getMeasureValue() {
        String value = this.load().toString();
        if (value == null || value.equals("")) {
            return value;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)value);
            return StringUtil.doubleToString((double)dimensionValue.getMeasure(), (int)3);
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle((Throwable)e);
            return "";
        }
    }

    public String[] getUnitItems() {
        return ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)ChoiceSetFactory.getDimensionChoiceSet((String)this.getElement(), (String)this.getProperty()));
    }

    public String getUnitName(String key) {
        IChoice choice = ChoiceSetFactory.getDimensionChoiceSet((String)this.getElement(), (String)this.getProperty()).findChoiceByDisplayName(key);
        if (choice == null) {
            return null;
        }
        return choice.getName();
    }

    public String getUnitDisplayName(String key) {
        IChoice choice = ChoiceSetFactory.getDimensionChoiceSet((String)this.getElement(), (String)this.getProperty()).findChoice(key);
        if (choice == null) {
            return null;
        }
        return choice.getDisplayName();
    }

    public String getUnit() throws PropertyValueException {
        String value = this.load().toString();
        if (value == null || value.equals("")) {
            return value;
        }
        DimensionValue dimensionValue = DimensionValue.parse((String)value);
        return dimensionValue.getUnits();
    }

    public boolean validateDimensionValue(String value, String unit) {
        DimensionValue dimensionValue;
        block3: {
            String unitValue = ChoiceSetFactory.getDimensionChoiceSet((String)this.getElement(), (String)this.getProperty()).findChoiceByDisplayName(unit).getName();
            boolean val = true;
            try {
                dimensionValue = DimensionValue.parse((String)(String.valueOf(value) + unitValue));
                if (dimensionValue != null) break block3;
                return true;
            }
            catch (PropertyValueException propertyValueException) {
                return val;
            }
        }
        int size = DEUtil.getFontSizeIntValue((DesignElementHandle)((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)));
        double pointValue = CSSUtil.convertToPoint((Object)dimensionValue, (int)size);
        return pointValue < 1000000.0;
    }

    public String getDefaultUnit() {
        if (DEUtil.getInputElements((Object)this.input) == null || DEUtil.getInputSize((Object)this.input) == 0) {
            return null;
        }
        String unit = null;
        if (!DEUtil.getGroupElementHandle((List)DEUtil.getInputElements((Object)this.input)).isSameType()) {
            return null;
        }
        DesignElementHandle handle = (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input);
        unit = handle.getPropertyHandle(this.getProperty()).getDefaultUnit();
        if (unit != null) {
            if (!StringUtil.isBlank((String)unit)) {
                unit = ChoiceSetFactory.getDimensionChoiceSet((String)this.getElement(), (String)this.getProperty()).findChoice(unit).getDisplayName();
            }
            return unit;
        }
        return null;
    }
}

