/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormText;

public class FormTextSection
extends Section {
    protected FormText textField;
    protected String text;
    private boolean fillText = false;
    private int width = -1;
    IDescriptorProvider provider;
    private int height = -1;
    private Map map = new HashMap();

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public FormTextSection(String labelText, Composite parent, boolean formStyle) {
        super(labelText, parent, formStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getTextControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillText;
        }
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        } else {
            gd.grabExcessVerticalSpace = this.fillText;
            if (this.fillText) {
                gd.verticalAlignment = 4;
                if (this.displayLabel != null) {
                    gd = (GridData)this.displayLabel.getLayoutData();
                    gd.verticalAlignment = 16;
                }
            }
        }
        if (this.fillText) {
            gd = (GridData)this.textField.getLayoutData();
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
    }

    public FormText getTextControl() {
        return this.textField;
    }

    protected FormText getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = FormWidgetFactory.getInstance().createFormText(parent, false);
            this.textField.setLayoutData((Object)new GridData());
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FormTextSection.this.textField = null;
                }
            });
            if (this.text != null) {
                this.textField.setText(this.text, true, false);
            }
            for (String key : this.map.keySet()) {
                Object obj = this.map.get(key);
                if (obj instanceof Image) {
                    this.textField.setImage(key, (Image)obj);
                    continue;
                }
                if (!(obj instanceof Color)) continue;
                this.textField.setColor(key, (Color)obj);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        this.text = value;
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.textField.setText(value, true, false);
        }
    }

    public void load() {
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setInput(Object input) {
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillText() {
        return this.fillText;
    }

    public void setFillText(boolean fillText) {
        this.fillText = fillText;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.textField != null) {
            WidgetUtil.setExcludeGridData((Control)this.textField, isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.textField != null) {
            this.textField.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public void setImage(String key, Image image) {
        this.map.put(key, image);
        if (this.textField != null) {
            this.textField.setImage(key, image);
        }
    }

    public void setColor(String key, Color color) {
        this.map.put(key, color);
        if (this.textField != null) {
            this.textField.setColor(key, color);
        }
    }
}

