/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    private int style = 2056;
    protected String oldValue;
    protected List comboSelectList = new ArrayList();

    public CComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = this.isFormStyle() ? FormWidgetFactory.getInstance().createBirtCCombo(parent) : new CCombo(parent, this.style);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                CComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                CComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        if (this.comboSelectList.isEmpty()) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CComboPropertyDescriptor.this.handleComboSelectEvent();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CComboPropertyDescriptor.this.handleComboSelectEvent();
                }
            };
            this.addComboSelectionListener((SelectionListener)listener);
        }
        return this.combo;
    }

    protected void handleComboSelectEvent() {
        try {
            this.save(this.combo.getText());
        }
        catch (SemanticException e) {
            this.combo.setText(this.oldValue);
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    public void load() {
        if (this.getDescriptorProvider() instanceof DataSetDescriptorProvider) {
            String dataSetName;
            DataSetDescriptorProvider provider = (DataSetDescriptorProvider)this.getDescriptorProvider();
            if (!provider.isEnable()) {
                this.combo.setEnabled(false);
                this.combo.deselectAll();
                return;
            }
            this.combo.setEnabled(true);
            String selectedDataSetName = this.combo.getText();
            String[] oldList = this.combo.getItems();
            String[] newList = provider.getItems();
            if (!Arrays.asList(oldList).equals(Arrays.asList(newList))) {
                this.combo.setItems(newList);
                this.combo.setText(selectedDataSetName);
            }
            if (!(dataSetName = provider.load().toString()).equals(selectedDataSetName)) {
                this.combo.deselectAll();
                this.combo.setText(dataSetName);
            }
            this.oldValue = this.combo.getText();
        }
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    public void addComboSelectionListener(SelectionListener listener) {
        if (!this.comboSelectList.contains(listener)) {
            if (!this.comboSelectList.isEmpty()) {
                this.removeComboSelectionListener((SelectionListener)this.comboSelectList.get(0));
            }
            this.comboSelectList.add(listener);
            if (this.combo != null) {
                this.combo.addSelectionListener(listener);
            }
        }
    }

    public void removeComboSelectionListener(SelectionListener listener) {
        if (this.comboSelectList.contains(listener)) {
            this.comboSelectList.remove(listener);
            if (this.combo != null) {
                this.combo.removeSelectionListener(listener);
            }
        }
    }
}

