/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataSetColumnBindingsFormDescriptor
extends FormPropertyDescriptor {
    private DataSetColumnBindingsFormHandleProvider provider;
    protected Button btnRefresh;

    public DataSetColumnBindingsFormDescriptor(boolean formStyle) {
        super(formStyle);
        super.setStyle(3);
        super.setButtonWithDialog(false);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof DataSetColumnBindingsFormHandleProvider) {
            this.provider = (DataSetColumnBindingsFormHandleProvider)provider;
        }
    }

    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.provider.setTableViewer(this.getTableViewer());
        this.btnRefresh = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton((Composite)control, "", 8) : new Button((Composite)control, 2048);
        this.btnRefresh.setText(Messages.getString((String)"FormPage.Button.Binding.Refresh"));
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetColumnBindingsFormDescriptor.this.handleRefreshSelectEvent();
            }
        });
        this.btnRefresh.setEnabled(true);
        this.fullLayout();
        this.btnUp.setVisible(false);
        this.btnDown.setVisible(false);
        return control;
    }

    protected void handleRefreshSelectEvent() {
        this.provider.generateAllBindingColumns();
    }

    protected void fullLayout() {
        super.fullLayout();
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        if (this.btnRefresh != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
            data.left = new FormAttachment((Control)this.btnDel, 0, 16384);
            data.width = Math.max(60, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnRefresh.setLayoutData((Object)data);
        }
    }

    public void setInput(Object object) {
        super.setInput(object);
        if (DEUtil.getInputSize((Object)object) > 0) {
            Object element = DEUtil.getInputFirstElement((Object)object);
            this.setBindingObject((ReportElementHandle)element);
        }
        if (this.provider.isEnable() && this.provider.isEditable()) {
            this.btnRefresh.setEnabled(true);
        } else {
            this.btnRefresh.setEnabled(false);
        }
    }

    private void setBindingObject(ReportElementHandle bindingObject) {
        this.provider.setBindingObject(bindingObject);
    }
}

