/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.Currency;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatNumberDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatCurrencyNumPattern;
import org.eclipse.birt.report.designer.util.FormatCustomNumPattern;
import org.eclipse.birt.report.designer.util.FormatFixedNumPattern;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;
import org.eclipse.birt.report.designer.util.FormatPercentNumPattern;
import org.eclipse.birt.report.designer.util.FormatScientificNumPattern;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatNumberDescriptor
extends PropertyDescriptor
implements IFormatPage {
    private static final String PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW = Messages.getString((String)"FormatNumberPage.preview.invalidNumber");
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.preview.invalidFormatCode");
    private static final String LABEL_FORMAT_NUMBER_PAGE = Messages.getString((String)"FormatNumberPage.label.format.number.page");
    private static final String LABEL_CURRENCY_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.currency.settings");
    private static final String LABEL_CURRENCY_SYMBOL = Messages.getString((String)"FormatNumberPage.label.symbol");
    private static final String LABEL_FIXED_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.fixed.settings");
    private static final String LABEL_PERCENT_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.percent.settings");
    private static final String LABEL_USE_1000S_SEPARATOR = Messages.getString((String)"FormatNumberPage.label.use1000sSeparator");
    private static final String LABEL_USE_SYMBOL_SPACE = Messages.getString((String)"FormatNumberPage.label.useSymbolSpace");
    private static final String LABEL_SYMBOL_POSITION = Messages.getString((String)"FormatNumberPage.label.symbol.position");
    private static final String LABEL_NEGATIVE_NUMBERS = Messages.getString((String)"FormatNumberPage.label.negative.numbers");
    private static final String LABEL_SCIENTIFIC_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.scientific.settings");
    private static final String LABEL_DECIMAL_PLACES = Messages.getString((String)"FormatNumberPage.label.decimal.places");
    private static final String LABEL_CUSTOM_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.settings");
    private static final String LABEL_CUSTOM_SETTINGS_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.settings.lable");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.label.format.code");
    private static final String LABEL_CUSTOM_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.preview.group");
    private static final String LABEL_PREVIEW_NUMBER = Messages.getString((String)"FormatNumberPage.label.preview.number");
    private static final String LABEL_COSTOM_PREVIEW_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.preview.label");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.label.table.column.format.code");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatNumberPage.label.table.column.format.result");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.general.preview.group");
    private String pattern = null;
    private String category = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private HashMap categoryPageMaps;
    private HashMap categoryPatternMaps;
    private static final int FORMAT_TYPE_INDEX = 0;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private static final double DEFAULT_PREVIEW_NUMBER = 1234.56;
    private static final String DEFAULT_PREVIEW_TEXT = NumberFormat.getNumberInstance(Locale.getDefault()).format(1234.56);
    private static final String DEFAULT_LOCALE_TEXT = NumberFormat.getNumberInstance(Locale.getDefault()).format(1234.56);
    private static String[] symbols = new String[0];
    private CCombo typeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite currencyPage;
    private Composite fixedPage;
    private Composite percentPage;
    private Composite scientificPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Text previewTextBox;
    private Text formatCodeBox;
    private Label gPreviewLabel;
    private Label cPreviewLabel;
    private Label fPreviewLabel;
    private Label pPreviewLabel;
    private Label sPreviewLabel;
    private Label cusPreviewLabel;
    private CCombo cPlacesChoice;
    private CCombo cSymbolChoice;
    private CCombo cSymPosChoice;
    private CCombo fPlacesChoice;
    private CCombo pSymPosChoice;
    private CCombo pPlacesChoice;
    private CCombo sPlacesChoice;
    private Button cUseSep;
    private Button pUseSep;
    private Button fUseSep;
    private Button cUseSpace;
    private List cNegNumChoice;
    private List fNegNumChoice;
    private List pNegNumChoice;
    private Table table;
    private boolean hasLoaded = false;
    private boolean isDirty = false;
    private String previewText = null;
    private int pageAlignment;
    private SelectionListener mySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FormatNumberDescriptor.this.updatePreview();
            FormatNumberDescriptor.this.notifyFormatChange();
        }
    };
    private ModifyListener myModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (FormatNumberDescriptor.this.hasLoaded) {
                FormatNumberDescriptor.this.updatePreview();
            }
        }
    };
    private FocusListener myFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            FormatNumberDescriptor.this.notifyFormatChange();
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private Composite content;
    private FormatNumberDescriptorProvider provider;

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Messages.getString((String)"FormatNumberPage.currency.symbol.none"));
        list.add("\u00a5");
        list.add("$");
        list.add("\u20ac");
        list.add("\u00a3");
        list.add("DKK");
        String localSymbol = Currency.getInstance((Locale)Locale.getDefault()).getSymbol();
        if (localSymbol != null && !list.contains(localSymbol)) {
            list.add(1, localSymbol);
        }
        symbols = list.toArray(new String[0]);
    }

    public FormatNumberDescriptor() {
        this(0, true);
    }

    public FormatNumberDescriptor(int pageAlignment, boolean isFormStyle) {
        this.pageAlignment = pageAlignment;
        this.setFormStyle(isFormStyle);
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.provider.initChoiceArray();
        this.provider.getFormatTypes();
        if (this.pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
        return this.content;
    }

    public Control getControl() {
        return this.content;
    }

    protected void createContentsVirtically() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite(this.content, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle()).setText(LABEL_FORMAT_NUMBER_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(topContainer, 2056) : FormWidgetFactory.getInstance().createCCombo(topContainer, true);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberDescriptor.this.reLayoutSubPages();
                FormatNumberDescriptor.this.updatePreview();
                FormatNumberDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes());
        this.infoComp = new Composite(this.content, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    protected void createContentsHorizontally() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        Composite container = new Composite(this.content, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_NUMBER_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(container, 8) : FormWidgetFactory.getInstance().createCCombo(container, true);
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberDescriptor.this.reLayoutSubPages();
                FormatNumberDescriptor.this.updatePreview();
                FormatNumberDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes());
        this.infoComp = new Composite(this.content, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite(this.content, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_UNFORMATTED, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_GENERAL_NUMBER, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_CURRENCY, this.getCurrencyPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_FIXED, this.getFixedPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_PERCENT, this.getPercentPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC, this.getScientificPage(parent));
        this.categoryPageMaps.put(this.provider.NUMBER_FORMAT_TYPE_CUSTOM, this.getCustomPage(parent));
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private void createCategoryPatterns() {
        this.categoryPatternMaps = new HashMap();
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_GENERAL_NUMBER, new FormatNumberPattern());
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_CURRENCY, new FormatCurrencyNumPattern(this.provider.NUMBER_FORMAT_TYPE_CURRENCY));
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_FIXED, new FormatFixedNumPattern(this.provider.NUMBER_FORMAT_TYPE_FIXED));
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_PERCENT, new FormatPercentNumPattern(this.provider.NUMBER_FORMAT_TYPE_PERCENT));
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC, new FormatScientificNumPattern(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC));
        this.categoryPatternMaps.put(this.provider.NUMBER_FORMAT_TYPE_CUSTOM, new FormatCustomNumPattern(this.provider.NUMBER_FORMAT_TYPE_CUSTOM));
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.provider.fireFormatChanged(this.getCategory(), this.getPattern());
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.provider.addFormatChangeListener(listener);
    }

    public void setInput(Object object) {
        super.setInput(object);
        this.getDescriptorProvider().setInput(object);
    }

    public void load() {
        this.setEnabled(true);
        String[] result = (String[])this.provider.load();
        if (result == null) {
            this.setEnabled(false);
        } else if (result.length == 1) {
            this.setInput(result[0]);
        } else if (result.length == 2) {
            this.setInput(result[0], result[1]);
        }
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (this.provider.isBlank(fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr) {
        this.hasLoaded = false;
        this.initiatePageLayout(categoryStr, patternStr);
        this.reLayoutSubPages();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.hasLoaded = true;
    }

    public void setPreviewText(String preText) {
        if (preText == null) {
            this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.previewTextBox.setText(preText);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return this.provider.NUMBER_FORMAT_TYPE_UNFORMATTED;
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        return this.oldPattern == null ? p != null : !this.oldPattern.equals(p);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        this.content.setEnabled(enabled);
        this.setControlsEnabled(enabled);
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setDefaultPreviewText(String defText) {
        this.previewText = defText == null || this.provider.isBlank(defText) || !this.isValidNumber(defText) ? null : defText;
    }

    private boolean isValidNumber(String text) {
        try {
            NumberFormat.getNumberInstance(Locale.getDefault()).parse(text);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        String category;
        this.markDirty(this.hasLoaded);
        if (this.hasLoaded) {
            this.setFmtPatternFromControls();
        }
        if (this.provider.NUMBER_FORMAT_TYPE_UNFORMATTED.equals(category = this.provider.getCategory4DisplayName(this.typeChoicer.getText()))) {
            this.setCategory(this.provider.NUMBER_FORMAT_TYPE_UNFORMATTED);
            this.setPattern(null);
        } else {
            FormatNumberPattern fmtPattern = this.getFmtPattern4Category(category);
            this.setCategory(fmtPattern.getCategory());
            this.setPattern(fmtPattern.getPattern());
        }
        this.doPreview(this.getCategory(), this.getPattern());
    }

    private void doPreview(String category, String patternStr) {
        double num;
        if (this.getPreviewText() == null) {
            num = 1234.56;
        } else {
            try {
                num = NumberFormat.getNumberInstance(Locale.getDefault()).parse(this.getPreviewText()).doubleValue();
            }
            catch (ParseException e) {
                ExceptionHandler.handle((Throwable)e);
                num = 1234.56;
            }
        }
        if (category == null) {
            String fmtStr = this.getPreviewText();
            fmtStr = new NumberFormatter(patternStr).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_UNFORMATTED)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_GENERAL_NUMBER)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_CURRENCY)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.cPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_FIXED)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.fPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_PERCENT)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.pPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC)) {
            String fmtStr = new NumberFormatter(patternStr).format(num);
            this.sPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_CUSTOM)) {
            String fmtStr = this.provider.isBlank(this.previewTextBox.getText()) || this.isValidNumber(this.previewTextBox.getText()) ? new NumberFormatter(patternStr).format(num) : PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW;
            this.cusPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
    }

    public FormatNumberPattern getFmtPattern4Category(String category) {
        FormatNumberPattern fmtPattern = null;
        if (this.categoryPatternMaps != null) {
            fmtPattern = (FormatNumberPattern)this.categoryPatternMaps.get(category);
        }
        if (fmtPattern == null) {
            fmtPattern = new FormatNumberPattern();
        }
        return fmtPattern;
    }

    public Control getFmtPage4Category(String category) {
        Control page = null;
        if (this.categoryPageMaps != null) {
            page = (Control)this.categoryPageMaps.get(category);
        }
        if (page == null) {
            page = this.getGeneralPage(this.infoComp);
        }
        return page;
    }

    private void initiatePageLayout(String categoryStr, String patternStr) {
        if (categoryStr == null) {
            this.typeChoicer.select(0);
            return;
        }
        FormatNumberPattern fmtPattern = this.getFmtPattern4Category(categoryStr);
        fmtPattern.setPattern(patternStr);
        if (this.provider.NUMBER_FORMAT_TYPE_GENERAL_NUMBER.equals(categoryStr)) {
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else if (this.provider.NUMBER_FORMAT_TYPE_CURRENCY.equals(categoryStr)) {
            this.refreshCurrencySetting((FormatCurrencyNumPattern)fmtPattern);
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else if (this.provider.NUMBER_FORMAT_TYPE_FIXED.equals(categoryStr)) {
            this.refreshFixedSetting((FormatFixedNumPattern)fmtPattern);
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else if (this.provider.NUMBER_FORMAT_TYPE_PERCENT.equals(categoryStr)) {
            this.refreshPercentSetting((FormatPercentNumPattern)fmtPattern);
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else if (this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC.equals(categoryStr)) {
            this.refreshScientificSetting((FormatScientificNumPattern)fmtPattern);
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else if (this.provider.NUMBER_FORMAT_TYPE_CUSTOM.equals(categoryStr)) {
            this.refreshCustomSetting((FormatCustomNumPattern)fmtPattern);
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        } else {
            this.typeChoicer.select(0);
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.provider.getCategory4DisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = this.getFmtPage4Category(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals(this.provider.NUMBER_FORMAT_TYPE_CUSTOM) ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private void refreshCurrencySetting(FormatCurrencyNumPattern fmtPattern) {
        this.cPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.cUseSep.setSelection(fmtPattern.getUseSep());
        this.cUseSpace.setSelection(fmtPattern.getUseSpace());
        if (!this.provider.isBlank(fmtPattern.getSymbol())) {
            this.cSymbolChoice.setText(fmtPattern.getSymbol());
        }
        if (!this.provider.isBlank(fmtPattern.getSymPos())) {
            this.cSymPosChoice.setText(fmtPattern.getSymPos());
            this.cSymPosChoice.setEnabled(true);
        }
        if (fmtPattern.getUseBracket()) {
            this.cNegNumChoice.select(1);
        } else {
            this.cNegNumChoice.select(0);
        }
    }

    private void refreshFixedSetting(FormatFixedNumPattern fmtPattern) {
        this.fPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.fUseSep.setSelection(fmtPattern.getUseSep());
        if (fmtPattern.getUseBracket()) {
            this.fNegNumChoice.select(1);
        } else {
            this.fNegNumChoice.select(0);
        }
    }

    private void refreshPercentSetting(FormatPercentNumPattern fmtPattern) {
        this.pPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.pUseSep.setSelection(fmtPattern.getUseSep());
        this.pSymPosChoice.setText(fmtPattern.getSymPos());
        if (fmtPattern.getUseBracket()) {
            this.pNegNumChoice.select(1);
        } else {
            this.pNegNumChoice.select(0);
        }
    }

    private void refreshScientificSetting(FormatScientificNumPattern fmtPattern) {
        this.sPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
    }

    private void refreshCustomSetting(FormatCustomNumPattern fmtPattern) {
        this.formatCodeBox.setText(fmtPattern.getPattern() == null ? "" : fmtPattern.getPattern());
    }

    private void setFmtPatternFromControls() {
        if (this.categoryPatternMaps == null) {
            return;
        }
        String category = this.provider.getCategory4DisplayName(this.typeChoicer.getText());
        if (category.equals(this.provider.NUMBER_FORMAT_TYPE_CURRENCY)) {
            FormatCurrencyNumPattern pattern = (FormatCurrencyNumPattern)this.categoryPatternMaps.get(category);
            String places = this.cPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.cUseSep.getSelection());
            pattern.setUseSpace(this.cUseSpace.getSelection());
            pattern.setSymbol(this.cSymbolChoice.getText());
            pattern.setSymPos(this.cSymPosChoice.getText());
            pattern.setUseBracket(this.cNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals(this.provider.NUMBER_FORMAT_TYPE_FIXED)) {
            FormatFixedNumPattern pattern = (FormatFixedNumPattern)this.categoryPatternMaps.get(category);
            String places = this.fPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.fUseSep.getSelection());
            pattern.setUseBracket(this.fNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals(this.provider.NUMBER_FORMAT_TYPE_PERCENT)) {
            FormatPercentNumPattern pattern = (FormatPercentNumPattern)this.categoryPatternMaps.get(category);
            String places = this.pPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.pUseSep.getSelection());
            pattern.setSymPos(this.pSymPosChoice.getText());
            pattern.setUseBracket(this.pNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC)) {
            FormatScientificNumPattern pattern = (FormatScientificNumPattern)this.categoryPatternMaps.get(category);
            String places = this.sPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
        } else if (category.equals(this.provider.NUMBER_FORMAT_TYPE_CUSTOM)) {
            FormatCustomNumPattern pattern = (FormatCustomNumPattern)this.categoryPatternMaps.get(category);
            pattern.setPattern(this.formatCodeBox.getText().length() == 0 ? null : this.formatCodeBox.getText());
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.gPreviewLabel = this.createGeneralPreviewPart4Page(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCurrencyPage(Composite parent) {
        if (this.currencyPage == null) {
            this.currencyPage = new Composite(parent, 0);
            this.currencyPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCurrencySettingPart(this.currencyPage);
            this.cPreviewLabel = this.createGeneralPreviewPart4Page(this.currencyPage);
        }
        return this.currencyPage;
    }

    private Composite getFixedPage(Composite parent) {
        if (this.fixedPage == null) {
            this.fixedPage = new Composite(parent, 0);
            this.fixedPage.setLayout((Layout)this.createGridLayout4Page());
            this.createFixedSettingPart(this.fixedPage);
            this.fPreviewLabel = this.createGeneralPreviewPart4Page(this.fixedPage);
        }
        return this.fixedPage;
    }

    private Composite getPercentPage(Composite parent) {
        if (this.percentPage == null) {
            this.percentPage = new Composite(parent, 0);
            this.percentPage.setLayout((Layout)this.createGridLayout4Page());
            this.createPercentSettingPart(this.percentPage);
            this.pPreviewLabel = this.createGeneralPreviewPart4Page(this.percentPage);
        }
        return this.percentPage;
    }

    private Composite getScientificPage(Composite parent) {
        if (this.scientificPage == null) {
            this.scientificPage = new Composite(parent, 0);
            this.scientificPage.setLayout((Layout)this.createGridLayout4Page());
            this.createScientificSettingPart(this.scientificPage);
            this.sPreviewLabel = this.createGeneralPreviewPart4Page(this.scientificPage);
        }
        return this.scientificPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
                this.formatCodeBox = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(container, "", 4) : new Text(container, 2052);
                this.formatCodeBox.setLayoutData((Object)new GridData(768));
                this.formatCodeBox.addModifyListener(this.myModifyListener);
                this.formatCodeBox.addFocusListener(this.myFocusListener);
            }
            this.createCustomPreviewPart4Page(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.generalFormatCodePage, 258, this.isFormStyle());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            l.setLayoutData((Object)data);
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.customFormatCodePage, 258, this.isFormStyle());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            l.setLayoutData((Object)data);
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
            this.formatCodeBox = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(container, "", 4) : new Text(container, 2052);
            this.formatCodeBox.setLayoutData((Object)new GridData(768));
            this.formatCodeBox.addModifyListener(this.myModifyListener);
            this.formatCodeBox.addFocusListener(this.myFocusListener);
        }
        return this.customFormatCodePage;
    }

    private void createCurrencySettingPart(Composite parent) {
        Group setting = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        setting.setText(LABEL_CURRENCY_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        if (this.isFormStyle()) {
            layout.marginHeight = 3;
            layout.verticalSpacing = 4;
        } else {
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
        }
        setting.setLayout((Layout)layout);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle()).setText(LABEL_DECIMAL_PLACES);
        this.cPlacesChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 2564) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, false);
        this.cPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.cPlacesChoice.setLayoutData((Object)data);
        this.cPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.cPlacesChoice.addModifyListener(this.myModifyListener);
        this.cPlacesChoice.addFocusListener(this.myFocusListener);
        this.cPlacesChoice.select(2);
        this.cUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle());
        this.cUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        data = new GridData();
        data.horizontalSpan = 2;
        this.cUseSep.setLayoutData((Object)data);
        this.cUseSep.addSelectionListener(this.mySelectionListener);
        this.cUseSpace = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle());
        this.cUseSpace.setText(LABEL_USE_SYMBOL_SPACE);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.cUseSpace.setLayoutData((Object)gData);
        this.cUseSpace.addSelectionListener(this.mySelectionListener);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle()).setText(LABEL_CURRENCY_SYMBOL);
        this.cSymbolChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 12) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, true);
        this.cSymbolChoice.setLayoutData((Object)new GridData(256));
        this.cSymbolChoice.setItems(symbols);
        this.cSymbolChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormatNumberDescriptor.this.cSymbolChoice.getSelectionIndex() == 0) {
                    FormatNumberDescriptor.this.cSymPosChoice.deselectAll();
                    FormatNumberDescriptor.this.cSymPosChoice.setEnabled(false);
                } else if (!FormatNumberDescriptor.this.cSymPosChoice.isEnabled()) {
                    FormatNumberDescriptor.this.cSymPosChoice.setEnabled(true);
                    FormatNumberDescriptor.this.cSymPosChoice.select(1);
                }
                FormatNumberDescriptor.this.updatePreview();
                FormatNumberDescriptor.this.notifyFormatChange();
            }
        });
        this.cSymbolChoice.select(0);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle()).setText(LABEL_SYMBOL_POSITION);
        this.cSymPosChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 12) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, true);
        this.cSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.cSymPosChoice.setLayoutData((Object)new GridData(768));
        this.cSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.cSymPosChoice.setEnabled(false);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle());
        label.setLayoutData((Object)new GridData(2));
        label.setText(LABEL_NEGATIVE_NUMBERS);
        this.cNegNumChoice = !this.isFormStyle() ? new List((Composite)setting, 2564) : FormWidgetFactory.getInstance().createList((Composite)setting, 516);
        this.cNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.cNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        data = new GridData(1808);
        this.cNegNumChoice.setLayoutData((Object)data);
        this.cNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.cNegNumChoice.select(0);
    }

    private void createFixedSettingPart(Composite parent) {
        Group setting = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        setting.setText(LABEL_FIXED_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        if (this.isFormStyle()) {
            layout.marginHeight = 3;
            layout.verticalSpacing = 4;
        } else {
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
        }
        setting.setLayout((Layout)layout);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle());
        label.setText(LABEL_DECIMAL_PLACES);
        this.fPlacesChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 2564) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, false);
        this.fPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.fPlacesChoice.setLayoutData((Object)data);
        this.fPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.fPlacesChoice.addModifyListener(this.myModifyListener);
        this.fPlacesChoice.addFocusListener(this.myFocusListener);
        this.fPlacesChoice.select(2);
        this.fUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle());
        this.fUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.fUseSep.setLayoutData((Object)gData);
        this.fUseSep.addSelectionListener(this.mySelectionListener);
        label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle());
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.fNegNumChoice = !this.isFormStyle() ? new List((Composite)setting, 2564) : FormWidgetFactory.getInstance().createList((Composite)setting, 516);
        this.fNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.fNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        gData = new GridData(1808);
        this.fNegNumChoice.setLayoutData((Object)gData);
        this.fNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.fNegNumChoice.select(0);
    }

    private void createPercentSettingPart(Composite percent) {
        Group setting = !this.isFormStyle() ? new Group(percent, 0) : FormWidgetFactory.getInstance().createGroup(percent, "");
        setting.setText(LABEL_PERCENT_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        if (this.isFormStyle()) {
            layout.marginHeight = 3;
            layout.verticalSpacing = 4;
        } else {
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
        }
        setting.setLayout((Layout)layout);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle()).setText(LABEL_DECIMAL_PLACES);
        this.pPlacesChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 2564) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, false);
        this.pPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.pPlacesChoice.setLayoutData((Object)data);
        this.pPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.pPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.pPlacesChoice.select(2);
        this.pUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle());
        this.pUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.pUseSep.setLayoutData((Object)gData);
        this.pUseSep.addSelectionListener(this.mySelectionListener);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle()).setText(LABEL_SYMBOL_POSITION);
        this.pSymPosChoice = !this.isFormStyle() ? new CCombo((Composite)setting, 12) : FormWidgetFactory.getInstance().createCCombo((Composite)setting, true);
        this.pSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.pSymPosChoice.setLayoutData((Object)new GridData(768));
        this.pSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.pSymPosChoice.select(0);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle());
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.pNegNumChoice = !this.isFormStyle() ? new List((Composite)setting, 2564) : FormWidgetFactory.getInstance().createList((Composite)setting, 516);
        this.pNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.pNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        this.pNegNumChoice.setLayoutData((Object)new GridData(1808));
        this.pNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.pNegNumChoice.select(0);
    }

    private void createScientificSettingPart(Composite percent) {
        Group group = !this.isFormStyle() ? new Group(percent, 0) : FormWidgetFactory.getInstance().createGroup(percent, "");
        group.setText(LABEL_SCIENTIFIC_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_DECIMAL_PLACES);
        this.sPlacesChoice = !this.isFormStyle() ? new CCombo((Composite)group, 2560) : FormWidgetFactory.getInstance().createCCombo((Composite)group, false);
        this.sPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        data.widthHint = 60;
        this.sPlacesChoice.setLayoutData((Object)data);
        this.sPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.sPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.sPlacesChoice.select(2);
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_CUSTOM_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(1, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_CUSTOM_SETTINGS_LABEL);
        label.setLayoutData((Object)new GridData());
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart4Page(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_CUSTOM_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle()).setText(LABEL_PREVIEW_NUMBER);
        this.previewTextBox = !this.isFormStyle() ? new Text((Composite)group, 2052) : FormWidgetFactory.getInstance().createText((Composite)group, "", 4);
        this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatNumberDescriptor.this.setDefaultPreviewText(FormatNumberDescriptor.this.previewTextBox.getText());
                if (FormatNumberDescriptor.this.hasLoaded) {
                    FormatNumberDescriptor.this.updatePreview();
                }
            }
        });
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_COSTOM_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cusPreviewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x11000100, this.isFormStyle());
        this.cusPreviewLabel.setLayoutData((Object)new GridData(1808));
    }

    private Label createGeneralPreviewPart4Page(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewText = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle());
        previewText.setLayoutData((Object)new GridData(1808));
        return previewText;
    }

    private void createTable(Composite group) {
        this.table = !this.isFormStyle() ? new Table(group, 100352) : FormWidgetFactory.getInstance().createTable(group, 98304);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(120);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.NUMBER_FORMAT_TYPE_CURRENCY), new NumberFormatter(this.provider.getPatternForCategory(this.provider.NUMBER_FORMAT_TYPE_CURRENCY)).format(1234.56)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.NUMBER_FORMAT_TYPE_FIXED), new NumberFormatter(this.provider.getPatternForCategory(this.provider.NUMBER_FORMAT_TYPE_FIXED)).format(1234.56)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.NUMBER_FORMAT_TYPE_PERCENT), new NumberFormatter(this.provider.getPatternForCategory(this.provider.NUMBER_FORMAT_TYPE_PERCENT)).format(1234.56)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC), new NumberFormatter(this.provider.getPatternForCategory(this.provider.NUMBER_FORMAT_TYPE_SCIENTIFIC)).format(1234.56)});
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String pattern = FormatNumberDescriptor.this.provider.getPattern(displayName);
                FormatNumberDescriptor.this.formatCodeBox.setText(pattern);
                FormatNumberDescriptor.this.updatePreview();
                FormatNumberDescriptor.this.notifyFormatChange();
            }
        });
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabled(boolean b) {
        this.typeChoicer.setEnabled(b);
        this.cPlacesChoice.setEnabled(b);
        this.cUseSep.setEnabled(b);
        this.cUseSpace.setEnabled(b);
        this.cSymbolChoice.setEnabled(b);
        this.cSymPosChoice.setEnabled(b);
        if (b && this.cSymbolChoice.getSelectionIndex() == 0) {
            this.cSymPosChoice.setEnabled(false);
        }
        this.cNegNumChoice.setEnabled(b);
        this.fPlacesChoice.setEnabled(b);
        this.fUseSep.setEnabled(b);
        this.fNegNumChoice.setEnabled(b);
        this.pPlacesChoice.setEnabled(b);
        this.pUseSep.setEnabled(b);
        this.pSymPosChoice.setEnabled(b);
        this.pNegNumChoice.setEnabled(b);
        this.sPlacesChoice.setEnabled(b);
        this.formatCodeBox.setEnabled(b);
        this.previewTextBox.setEnabled(b);
        this.table.setEnabled(b);
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof FormatNumberDescriptorProvider) {
            this.provider = (FormatNumberDescriptorProvider)provider;
        }
    }
}

