/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatStringDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FormatStringPattern;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatStringDescriptor
extends PropertyDescriptor
implements IFormatPage {
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatStringPage.previewText.invalidFormatCode");
    private static final String LABEL_FORMAT_STRING_PAGE = Messages.getString((String)"FormatStringPage.label.formatStringAs");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatStringPage.label.previewWithFormat");
    private static final String LABEL_CUSTOM_SETTINGS_GROUP = Messages.getString((String)"FormatStringPage.label.customSettings");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatStringPage.label.format.code");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatStringPage.label.table.collumn.exampleFormatCode");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatStringPage.label.table.collumn.exampleFormatResult");
    private static final String LABEL_CUSTOM_PREVIEW_LABEL = Messages.getString((String)"FormatStringPage.label.custom.preview.label");
    private static final String LABEL_CUSTOM_PREVIEW_GROUP = Messages.getString((String)"FormatStringPage.label.preview.group");
    private static final String LABEL_CUSTOM_SETTING_TEXT = Messages.getString((String)"FormatStringPage.label.custom.settings.label");
    private static final String LABEL_CUSTOM_PREVIEW_STRING = Messages.getString((String)"FormatStringPage.label.preview.string");
    private static final String SAMPLE_TEXT_ZIP_CODE = Messages.getString((String)"FormatStringPage.SimpleTextZipCode");
    private static final String SAMPLE_TEXT_ZIP_C0DE4 = Messages.getString((String)"FormatStringPage.SimpleTextZipCode4");
    private static final String SAMPLE_TEXT_PHONE_NUMBER = Messages.getString((String)"FormatStringPage.PhoneNumber");
    private static final String SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER = Messages.getString((String)"FormatStringPage.SocialSecurityNumber");
    private static final String SAMPLE_TEXT_PRESERVE_SPACE = Messages.getString((String)"FormatStringPage.Preview.PreserveWhiteSpaces");
    private static final String DEFAULT_PREVIEW_TEXT = Messages.getString((String)"FormatStringPage.default.preview.text");
    ULocale DEFAULT_LOCALE = ULocale.getDefault();
    private String pattern = null;
    private String category = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private HashMap categoryPageMaps;
    private static final int FORMAT_TYPE_INDEX = 0;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private CCombo typeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Label generalPreviewLabel;
    private Label cPreviewLabel;
    private Text formatCode;
    private Text previewTextBox;
    private boolean hasLoaded = false;
    private String previewText = null;
    private boolean isDirty = false;
    private int pageAlignment;
    private Table table;
    private FormatStringDescriptorProvider provider;
    private Composite content;

    public FormatStringDescriptor() {
        this(0, true);
    }

    public FormatStringDescriptor(int pageAlignment, boolean isFormStyle) {
        this.pageAlignment = pageAlignment;
        this.setFormStyle(isFormStyle);
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.provider.initChoiceArray();
        this.provider.getFormatTypes();
        if (this.pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
        return this.content;
    }

    public Control getControl() {
        return this.content;
    }

    protected void createContentsVirtically() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite(this.content, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle()).setText(LABEL_FORMAT_STRING_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(topContainer, 2056) : FormWidgetFactory.getInstance().createCCombo(topContainer, true);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatStringDescriptor.this.reLayoutSubPages();
                FormatStringDescriptor.this.updatePreview();
                FormatStringDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes());
        this.infoComp = new Composite(this.content, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    protected void createContentsHorizontally() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        Composite container = new Composite(this.content, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_STRING_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(container, 8) : FormWidgetFactory.getInstance().createCCombo(container, true);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatStringDescriptor.this.reLayoutSubPages();
                FormatStringDescriptor.this.updatePreview();
                FormatStringDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes());
        this.infoComp = new Composite(this.content, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite(this.content, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put(this.provider.STRING_FORMAT_TYPE_UNFORMATTED, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.STRING_FORMAT_TYPE_UPPERCASE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.STRING_FORMAT_TYPE_LOWERCASE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.STRING_FORMAT_TYPE_CUSTOM, this.getCustomPage(parent));
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.provider.fireFormatChanged(this.getCategory(), this.getPattern());
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.provider.addFormatChangeListener(listener);
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (this.provider.isBlank(fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr) {
        this.hasLoaded = false;
        this.initiatePageLayout(categoryStr, patternStr);
        this.reLayoutSubPages();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.hasLoaded = true;
    }

    public void setPreviewText(String preText) {
        if (preText == null) {
            this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.previewTextBox.setText(preText);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return this.provider.STRING_FORMAT_TYPE_UNFORMATTED;
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        return this.oldPattern == null ? p != null : !this.oldPattern.equals(p);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        this.content.setEnabled(enabled);
        this.setControlsEnabeld(enabled);
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setDefaultPreviewText(String defText) {
        this.previewText = defText == null || this.provider.isBlank(defText) ? null : defText;
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        this.markDirty(this.hasLoaded);
        String gText = this.getPreviewText() == null ? DEFAULT_PREVIEW_TEXT : this.getPreviewText();
        String category = this.provider.getCategory4DisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        if (this.provider.STRING_FORMAT_TYPE_UNFORMATTED.equals(category)) {
            String pattern = null;
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(null);
        } else if (this.provider.STRING_FORMAT_TYPE_UPPERCASE.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_LOWERCASE.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_ZIP_CODE.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_CODE);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_ZIP_CODE_4.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_C0DE4);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_PHONE_NUMBER.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_PHONE_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_SOCIAL_SECURITY_NUMBER.equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            gText = SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER;
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if (this.provider.STRING_FORMAT_TYPE_CUSTOM.equals(category)) {
            String pattern = this.formatCode.getText();
            String fmtStr = this.provider.isBlank(this.previewTextBox.getText()) ? new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText) : new StringFormatter(pattern, this.DEFAULT_LOCALE).format(this.previewTextBox.getText());
            this.cPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        }
    }

    private void initiatePageLayout(String categoryStr, String patternStr) {
        if (categoryStr == null) {
            this.typeChoicer.select(0);
        } else {
            if (categoryStr.equals(this.provider.STRING_FORMAT_TYPE_CUSTOM)) {
                this.formatCode.setText(patternStr == null ? "" : patternStr);
            }
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.provider.getCategory4DisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = (Control)this.categoryPageMaps.get(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals(this.provider.STRING_FORMAT_TYPE_CUSTOM) ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
                this.formatCode = !this.isFormStyle() ? new Text(container, 2052) : FormWidgetFactory.getInstance().createText(container, "", 4);
                this.formatCode.setLayoutData((Object)new GridData(768));
                this.formatCode.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FormatStringDescriptor.this.hasLoaded) {
                            FormatStringDescriptor.this.updatePreview();
                        }
                    }
                });
                this.formatCode.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FormatStringDescriptor.this.notifyFormatChange();
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.createCustomPreviewPart(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.generalFormatCodePage, 258, this.isFormStyle());
            l.setLayoutData((Object)new GridData(768));
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.customFormatCodePage, 258, this.isFormStyle());
            l.setLayoutData((Object)new GridData(768));
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
            this.formatCode = !this.isFormStyle() ? new Text(container, 2052) : FormWidgetFactory.getInstance().createText(container, "", 4);
            this.formatCode.setLayoutData((Object)new GridData(768));
            this.formatCode.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FormatStringDescriptor.this.hasLoaded) {
                        FormatStringDescriptor.this.updatePreview();
                    }
                }
            });
            this.formatCode.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FormatStringDescriptor.this.notifyFormatChange();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.customFormatCodePage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewText = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle());
        previewText.setLayoutData((Object)new GridData(768));
        return previewText;
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_CUSTOM_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_CUSTOM_SETTING_TEXT);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_CUSTOM_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle()).setText(LABEL_CUSTOM_PREVIEW_STRING);
        this.previewTextBox = !this.isFormStyle() ? new Text((Composite)group, 2052) : FormWidgetFactory.getInstance().createText((Composite)group, "", 4);
        this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatStringDescriptor.this.setDefaultPreviewText(FormatStringDescriptor.this.previewTextBox.getText());
                if (FormatStringDescriptor.this.hasLoaded) {
                    FormatStringDescriptor.this.updatePreview();
                }
            }
        });
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_CUSTOM_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cPreviewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x11000100, this.isFormStyle());
        this.cPreviewLabel.setText("");
        data = new GridData(1808);
        data.horizontalSpan = 1;
        this.cPreviewLabel.setLayoutData((Object)data);
    }

    private void createTable(Composite parent) {
        this.table = !this.isFormStyle() ? new Table(parent, 100352) : FormWidgetFactory.getInstance().createTable(parent, 98304);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String category = null;
                category = displayName.equals(FormatStringDescriptorProvider.PRESERVE_WHITE_SPACES) ? ((FormatStringDescriptor)FormatStringDescriptor.this).provider.STRING_FORMAT_TYPE_PRESERVE_SPACE : ChoiceSetFactory.getStructPropValue((String)((FormatStringDescriptor)FormatStringDescriptor.this).provider.FORMAT_VALUE_STRUCT, (String)((FormatStringDescriptor)FormatStringDescriptor.this).provider.CATEGORY_MEMBER, (String)displayName);
                String pattern = FormatStringPattern.getPatternForCategory((String)category);
                FormatStringDescriptor.this.formatCode.setText(pattern);
                FormatStringDescriptor.this.updatePreview();
                FormatStringDescriptor.this.notifyFormatChange();
            }
        });
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(150);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(200);
        tableColumnDisplay.setResizable(true);
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_UPPERCASE), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_UPPERCASE), this.DEFAULT_LOCALE).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_LOWERCASE), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_LOWERCASE), this.DEFAULT_LOCALE).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_ZIP_CODE_4), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_ZIP_CODE_4), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_C0DE4)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_PHONE_NUMBER), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_PHONE_NUMBER), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_PHONE_NUMBER)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_SOCIAL_SECURITY_NUMBER), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_SOCIAL_SECURITY_NUMBER), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER)});
        new TableItem(this.table, 0).setText(new String[]{this.provider.getDisplayName4Category(this.provider.STRING_FORMAT_TYPE_PRESERVE_SPACE), new StringFormatter(FormatStringPattern.getPatternForCategory((String)this.provider.STRING_FORMAT_TYPE_PRESERVE_SPACE), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_PRESERVE_SPACE)});
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabeld(boolean b) {
        this.typeChoicer.setEnabled(b);
        this.formatCode.setEnabled(b);
        this.previewTextBox.setEnabled(b);
        this.table.setEnabled(b);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof FormatStringDescriptorProvider) {
            this.provider = (FormatStringDescriptorProvider)provider;
        }
    }

    public void load() {
        this.setEnabled(true);
        String[] format = (String[])this.provider.load();
        if (format == null) {
            this.setInput(null, null);
            this.setEnabled(false);
        } else {
            this.setInput(format[0], format[1]);
        }
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.getDescriptorProvider().setInput(input);
    }
}

