/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PreviewPropertyDescriptor;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.swt.widgets.Composite;

public class HighlightPropertyDescriptor
extends PreviewPropertyDescriptor {
    protected HighlightDescriptorProvider provider;

    public HighlightPropertyDescriptor(boolean formStyle) {
        super(formStyle);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof HighlightDescriptorProvider) {
            this.provider = (HighlightDescriptorProvider)provider;
        }
    }

    protected void updatePreview(Object handle) {
        if (handle != null) {
            String familyValue = this.provider.getFontFamily(handle);
            int sizeValue = this.provider.getFontSize(handle);
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setBold(this.provider.isBold(handle));
            this.previewLabel.setItalic(this.provider.isItalic(handle));
            this.previewLabel.setForeground(this.provider.getColor(handle));
            this.previewLabel.setBackground(this.provider.getBackgroundColor(handle));
            this.previewLabel.setUnderline(this.provider.isUnderline(handle));
            this.previewLabel.setLinethrough(this.provider.isLinethrough(handle));
            this.previewLabel.setOverline(this.provider.isOverline(handle));
            this.previewLabel.updateView();
            if (this.provider.getBackgroundColor(handle) == null && this.isFormStyle()) {
                FormWidgetFactory.getInstance().paintFormStyle((Composite)this.previewLabel);
                FormWidgetFactory.getInstance().adapt((Composite)this.previewLabel);
            }
        } else {
            this.previewLabel.restoreDefaultState();
            this.previewLabel.setForeground(ColorManager.getColor((int)-1));
            this.previewLabel.setBackground(ColorManager.getColor((int)-1));
            this.previewLabel.updateView();
            if (this.isFormStyle()) {
                FormWidgetFactory.getInstance().paintFormStyle((Composite)this.previewLabel);
                FormWidgetFactory.getInstance().adapt((Composite)this.previewLabel);
            }
        }
    }
}

