/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSourceSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.WizardUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class DataSetNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((DataSetHandle)object).canEdit()) {
            WizardUtil.createEditDataSetMenu((IMenuManager)menu, (Object)object);
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        menu.insertAfter("additions-refresh", (IAction)new RefreshAction(sourceViewer));
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model, (boolean)false);
    }

    public Object[] getChildren(Object object) {
        PropertyHandle parameters;
        Iterator iter;
        DataSetHandle handle = (DataSetHandle)object;
        ArrayList params = new ArrayList(10);
        CachedMetaDataHandle cmdh = null;
        try {
            cmdh = DataSetUIUtil.getCachedMetaDataHandle((DataSetHandle)handle);
        }
        catch (SemanticException semanticException) {}
        ArrayList<ResultSetColumnHandle> columns = new ArrayList<ResultSetColumnHandle>(10);
        if (cmdh != null) {
            for (ResultSetColumnHandle element : cmdh.getResultSet()) {
                columns.add(element);
            }
        }
        if ((iter = (parameters = handle.getPropertyHandle("parameters")).iterator()) != null) {
            while (iter.hasNext()) {
                Object dataSetParameter = iter.next();
                if (!((DataSetParameterHandle)dataSetParameter).isOutput()) continue;
                params.add(dataSetParameter);
            }
        }
        Object[] parametersArray = params.toArray();
        Object[] both = new Object[columns.toArray().length + parametersArray.length];
        System.arraycopy(columns.toArray(), 0, both, 0, columns.toArray().length);
        System.arraycopy(parametersArray, 0, both, columns.toArray().length, parametersArray.length);
        return both;
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        DataSetEditor dialog;
        DataSetHandle dsHandle = (DataSetHandle)handle;
        if (!(dsHandle instanceof JointDataSetHandle) && dsHandle.getDataSource() == null) {
            DataSourceSelectionDialog dataSorucedialog;
            block5: {
                try {
                    List dataSourceList = DEUtil.getDataSources();
                    String[] names = new String[dataSourceList.size()];
                    int i = 0;
                    while (i < names.length) {
                        names[i] = ((DataSourceHandle)dataSourceList.get(i)).getName();
                        ++i;
                    }
                    dataSorucedialog = new DataSourceSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"dataSourceSelectionPage.title"), names);
                    if (dataSorucedialog.open() != 1) break block5;
                    return false;
                }
                catch (SemanticException semanticException) {}
            }
            dsHandle.setDataSource(dataSorucedialog.getResult().toString());
        }
        return (dialog = new DataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (DataSetHandle)handle, false)).open() == 0;
    }
}

