/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.BirtImageLoader;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertEmbeddedImageAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;

public class EmbeddedImagesNodeProvider
extends DefaultNodeProvider {
    private static String[] EXTENSIONS = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".svg"};
    private static String[] ALLEXTENSIONS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.svg"};

    public Object[] getChildren(Object model) {
        return ((EmbeddedImageNode)model).getChildren();
    }

    public String getIconName(Object model) {
        return "Image";
    }

    public String getNodeDisplayName(Object model) {
        return IMAGES;
    }

    public Object getParent(Object model) {
        return ((EmbeddedImageNode)model).getReportDesignHandle();
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertEmbeddedImageAction(object, Messages.getString((String)"EmbeddedImagesNodeProvider.action.New")));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public boolean performRequest(Object model, Request request) throws Exception {
        if (request.getType().equals("insert")) {
            String fileName;
            String fullPath;
            CommandStack stack;
            block6: {
                block5: {
                    FileDialog fileChooser = new FileDialog(UIUtil.getDefaultShell(), 4096);
                    fileChooser.setText(Messages.getString((String)"ImageBuilder.Chooser.Title"));
                    fileChooser.setFilterExtensions(ALLEXTENSIONS);
                    stack = SessionHandleAdapter.getInstance().getCommandStack();
                    fullPath = fileChooser.open();
                    fileName = fileChooser.getFileName();
                    if (fullPath != null && !"".equalsIgnoreCase(fullPath)) break block5;
                    return false;
                }
                if (this.checkExtensions(fileName)) break block6;
                ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), (String)Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                return false;
            }
            try {
                stack.startTrans(Messages.getString((String)"EmbeddedImagesNodeProvider.stackMsg.insert"));
                BirtImageLoader imageLoader = new BirtImageLoader();
                imageLoader.save(SessionHandleAdapter.getInstance().getReportDesignHandle(), fullPath, fileName);
                stack.commit();
                return true;
            }
            catch (Throwable e) {
                stack.rollback();
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return false;
    }

    private boolean checkExtensions(String fileName) {
        fileName = fileName.toLowerCase();
        int i = 0;
        while (i < EXTENSIONS.length) {
            if (fileName.endsWith(EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

