/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AdvancePropertyPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AlterPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BaseAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BookMarkExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BordersPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CategoryPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CellPaddingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FontPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.HyperLinkPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ItemMarginPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.NamedExpressionsPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.PreviewPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.SectionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.TOCExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.UserPropertiesPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.VisibilityPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.HighlightPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IPropertyTabUI;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AttributesUtil {
    public static final String GENERAL = "General";
    public static final String FONT = "Font";
    public static final String PADDING = "Padding";
    public static final String ALT = "AltText";
    public static final String BORDER = "Borders";
    public static final String MARGIN = "Margin";
    public static final String HYPERLINK = "HyperLink";
    public static final String SECTION = "Section";
    public static final String VISIBILITY = "Visibility";
    public static final String TOC = "TOC";
    public static final String BOOKMARK = "Bookmark";
    public static final String USERPROPERTIES = "UserProperties";
    public static final String NAMEDEXPRESSIONS = "NamedExpressions";
    public static final String ADVANCEPROPERTY = "AdvanceProperty";
    public static final String EVENTHANDLER = "EventHandler";
    private static Map categoryMap = new HashMap();
    private static Map paneClassMap = new HashMap();

    static {
        AttributesUtil.addCategory(FONT, "GridPageGenerator.List.Font", FontPage.class);
        AttributesUtil.addCategory(PADDING, "DataPageGenerator.List.Padding", CellPaddingPage.class);
        AttributesUtil.addCategory(ALT, "ImagePageGenerator.List.AltText", AlterPage.class);
        AttributesUtil.addCategory(BORDER, "DataPageGenerator.List.Borders", BordersPage.class);
        AttributesUtil.addCategory(MARGIN, "DataPageGenerator.List.Margin", ItemMarginPage.class);
        AttributesUtil.addCategory(HYPERLINK, "DataPageGenerator.List.HyperLink", HyperLinkPage.class);
        AttributesUtil.addCategory(SECTION, "DataPageGenerator.List.Section", SectionPage.class);
        AttributesUtil.addCategory(VISIBILITY, "DataPageGenerator.List.Visibility", VisibilityPage.class);
        AttributesUtil.addCategory(TOC, "DataPageGenerator.List.TOC", TOCExpressionPage.class);
        AttributesUtil.addCategory(BOOKMARK, "DataPageGenerator.List.Bookmark", BookMarkExpressionPage.class);
        AttributesUtil.addCategory(USERPROPERTIES, "ReportPageGenerator.List.UserProperties", UserPropertiesPage.class);
        AttributesUtil.addCategory(NAMEDEXPRESSIONS, "ReportPageGenerator.List.NamedExpressions", NamedExpressionsPage.class);
        AttributesUtil.addCategory(ADVANCEPROPERTY, "ReportPageGenerator.List.AdvancedProperty", AdvancePropertyPage.class);
    }

    public static void addCategory(String id, String displayLabelKey, Class pageClass) {
        Assert.isNotNull((Object)id);
        categoryMap.put(id, displayLabelKey);
        paneClassMap.put(id, pageClass);
    }

    public static IPropertyTabUI buildGeneralPage(Composite parent, String[] categories, String[] customKeys, String[] customCategories, PageWrapper[] customPageWrappers, Object input) {
        BaseAttributePage basicPage = new BaseAttributePage();
        SortMap categorys = new SortMap();
        ArrayList<PageWrapper> paneClassList = new ArrayList<PageWrapper>();
        if (categories == null) {
            if (customCategories != null && customPageWrappers != null) {
                int i = 0;
                while (i < customCategories.length) {
                    categorys.put(customKeys[i], customCategories[i]);
                    paneClassList.add(customPageWrappers[i]);
                    ++i;
                }
            }
        } else {
            int customIndex = 0;
            int i = 0;
            while (i < categories.length) {
                if (categories[i] == null) {
                    if (customCategories != null && customPageWrappers != null && customCategories.length > customIndex) {
                        categorys.put(customKeys[customIndex], customCategories[customIndex]);
                        paneClassList.add(customPageWrappers[customIndex]);
                        ++customIndex;
                    }
                } else {
                    Object cat = categoryMap.get(categories[i]);
                    if (cat instanceof String) {
                        categorys.put(categories[i], cat);
                        paneClassList.add((PageWrapper)paneClassMap.get(categories[i]));
                    }
                }
                ++i;
            }
            if (customCategories != null && customPageWrappers != null && customCategories.length > customIndex) {
                i = customIndex;
                while (i < customCategories.length) {
                    categorys.put(customKeys[customIndex], customCategories[customIndex]);
                    paneClassList.add(customPageWrappers[customIndex]);
                    ++customIndex;
                    ++i;
                }
            }
        }
        Object[] clss = paneClassList.toArray(new Object[0]);
        basicPage.setCategoryProvider(new ExtendedCategoryProvider(categorys, clss));
        basicPage.setInput(input);
        basicPage.buildUI(parent);
        return basicPage;
    }

    public static String getGeneralPageDisplayName() {
        return Messages.getString((String)"CategoryPageGenerator.TabItem.Attributes");
    }

    public static IPropertyTabUI buildBindingPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        BindingPage page = new BindingPage();
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getBindingPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Binding");
    }

    public static IPropertyTabUI buildFilterPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        FormPage page = new FormPage(3, new FilterHandleProvider(), true, true);
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getFilterPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Filters");
    }

    public static IPropertyTabUI buildHighlightPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        PreviewPage page = new PreviewPage(true);
        page.setPreview(new HighlightPropertyDescriptor(true));
        page.setProvider(new HighlightDescriptorProvider());
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getHighlightPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Highlights");
    }

    public static void setPageInput(IPropertyTabUI page, Object input) {
        page.setInput(input);
        if (page instanceof TabPage && page.getControl() != null) {
            ((TabPage)page).refresh();
        }
    }

    public static void handleError(Throwable e) {
        ExceptionHandler.handle((Throwable)e);
    }

    public static boolean containCategory(String categoryId) {
        return categoryMap.containsKey(categoryId);
    }

    public static ICategoryPage getCategory(String categoryId) {
        return new CategoryPage(categoryId, Messages.getString((String)categoryMap.get(categoryId).toString()), (Class)paneClassMap.get(categoryId));
    }

    public static String getCategoryDisplayName(String categoryId) {
        return Messages.getString((String)categoryMap.get(categoryId).toString());
    }

    static class ExtendedCategoryProvider
    implements ICategoryProvider {
        private SortMap categories;
        private Object[] paneObjects;

        ExtendedCategoryProvider(SortMap categories, Object[] paneObjects) {
            Assert.isNotNull((Object)categories);
            Assert.isNotNull((Object)paneObjects);
            Assert.isLegal((categories.size() == paneObjects.length ? 1 : 0) != 0);
            this.categories = categories;
            this.paneObjects = paneObjects;
        }

        public ICategoryPage[] getCategories() {
            ArrayList<ICategoryPage> pageList = new ArrayList<ICategoryPage>(this.categories.size());
            int i = 0;
            while (i < this.categories.size()) {
                final String displayLabel = Messages.getString((String)this.categories.getValue(i).toString());
                final String categoryKey = this.categories.getKeyList().get(i).toString();
                final Object pane = this.paneObjects[i];
                if (pane instanceof Class) {
                    pageList.add(new CategoryPage(this.categories.getKeyList().get(i).toString(), displayLabel, (Class)pane));
                } else if (pane instanceof PageWrapper) {
                    pageList.add(new ICategoryPage(){

                        public String getDisplayLabel() {
                            return displayLabel;
                        }

                        public TabPage createPage() {
                            return ((PageWrapper)pane).getPage();
                        }

                        public String getCategoryKey() {
                            return categoryKey;
                        }
                    });
                }
                ++i;
            }
            return pageList.toArray(new ICategoryPage[0]);
        }
    }

    public static abstract class PageWrapper
    implements IModelEventProcessor {
        private AttributePage page;

        public TabPage getPage() {
            if (this.page == null) {
                this.page = new AttributePage(){

                    public void buildUI(Composite parent) {
                        super.buildUI(parent);
                        PageWrapper.this.buildUI(parent);
                    }

                    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
                        PageWrapper.this.addElementEvent(focus, ev);
                    }

                    public void clear() {
                        PageWrapper.this.clear();
                    }

                    public void postElementEvent() {
                        PageWrapper.this.postElementEvent();
                    }

                    public Object getAdapter(Class adapter) {
                        return PageWrapper.this.getAdapter(adapter);
                    }

                    public void refresh() {
                        PageWrapper.this.refresh();
                        super.refresh();
                    }

                    public void setInput(Object elements) {
                        super.setInput(elements);
                        PageWrapper.this.setInput(elements);
                    }

                    public void dispose() {
                        PageWrapper.this.dispose();
                        super.dispose();
                    }
                };
            }
            return this.page;
        }

        public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
        }

        public void clear() {
        }

        public void postElementEvent() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public abstract void buildUI(Composite var1);

        public void setInput(Object input) {
        }

        public void refresh() {
        }

        public void dispose() {
        }
    }
}

