/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.sqltools.sql.parser.ParseException;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;

public class ParserProposalAdvisor {
    private static final String[] EMPTY = new String[0];

    public String getLocalVariablePrefix() {
        return "@";
    }

    public String getGlobalVariablePrefix() {
        return "@@";
    }

    public boolean isLocalVariableTokenDefinition(String token) {
        return token != null && token.equalsIgnoreCase("<VAR_NAME>");
    }

    public boolean isGlobalVariableTokenDefinition(String token) {
        return token != null && token.equalsIgnoreCase("<GLOBAL_VAR_NAME>");
    }

    public boolean isIdentifierTokenDefinition(String token) {
        return token != null && token.equalsIgnoreCase("<ID>");
    }

    public boolean isTokenDefinition(String token) {
        return token.startsWith("<") && token.endsWith(">") || token.charAt(0) == '\"';
    }

    public boolean isTokenName(String token) {
        boolean isName = token != null && token.startsWith("<") && token.endsWith(">");
        isName = isName || token != null && token.charAt(0) == '\"';
        return isName;
    }

    public String[] getParserProposals(ParsingResult result) {
        if (result.getExceptions() == null || result.getExceptions().size() == 0) {
            return EMPTY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int lookaheadDepth = 1;
        int i = 0;
        while (i < result.getExceptions().size()) {
            if (result.getExceptions().get(i) instanceof ParseException) {
                ParseException pe = (ParseException)result.getExceptions().get(i);
                if (pe.expectedTokenSequences != null) {
                    int j = 0;
                    while (j < pe.expectedTokenSequences.length) {
                        int[] sequence = pe.expectedTokenSequences[j];
                        if (sequence.length >= lookaheadDepth) {
                            String image;
                            String expected;
                            if (sequence.length > lookaheadDepth) {
                                list = new ArrayList();
                                lookaheadDepth = sequence.length;
                            }
                            if (!list.contains(expected = this.removeQuotes(image = pe.tokenImage[sequence[sequence.length - 1]]))) {
                                list.add(expected);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String removeQuotes(String string) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\\') {
                sb.append(c);
            } else if (c == '\\' && string.charAt(i + 1) == '\"') {
                sb.append('\"');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean containsDataTypeProposals(String[] parserProposals, Collection unreservedKeywords) {
        String proposal;
        int count = 0;
        int i = 0;
        while (i < parserProposals.length) {
            proposal = parserProposals[i].toLowerCase();
            if ((proposal.equals("char") || proposal.equals("varchar") || proposal.equals("int")) && ++count == 3) break;
            ++i;
        }
        if (count == 0) {
            Iterator iter = unreservedKeywords.iterator();
            while (iter.hasNext()) {
                proposal = (String)iter.next();
                if ((proposal.equals("char") || proposal.equals("varchar") || proposal.equals("int")) && ++count == 3) break;
            }
        }
        return count == 3;
    }

    public boolean acceptsUserDefinedDataType(UserDefinedType udt) {
        return true;
    }
}

