/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.sql.internal.SQLImages;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sql.parser.util.Messages;
import org.eclipse.swt.graphics.Image;

public class ASTSQLStatementUtil {
    public static String toString(int type, SimpleNode node, Collection params) {
        String s = ASTSQLStatementUtil.toString(type, node);
        if (params != null && params.size() > 0) {
            s = String.valueOf(s) + "(";
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                s = String.valueOf(s) + name;
                if (!iter.hasNext()) continue;
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + ")";
        }
        return s;
    }

    public static String toString(int type, SimpleNode node) {
        switch (type) {
            case 51: {
                return Messages.getString("ASTSQLStatement.select");
            }
            case 52: {
                return Messages.getString("ASTSQLStatement.insert");
            }
            case 53: {
                return Messages.getString("ASTSQLStatement.delete");
            }
            case 54: {
                return Messages.getString("ASTSQLStatement.update");
            }
            case 55: {
                return Messages.getString("ASTSQLStatement.create.database");
            }
            case 155: {
                return Messages.getString("ASTSQLStatement.alter.database");
            }
            case 56: {
                return Messages.getString("ASTSQLStatement.create.table");
            }
            case 156: {
                return Messages.getString("ASTSQLStatement.alter.table");
            }
            case 57: {
                return Messages.getString("ASTSQLStatement.create.view");
            }
            case 157: {
                return Messages.getString("ASTSQLStatement.alter.view");
            }
            case 257: {
                return Messages.getString("ASTSQLStatement.drop.view");
            }
            case 58: {
                return Messages.getString("ASTSQLStatement.create.procedure");
            }
            case 158: {
                return Messages.getString("ASTSQLStatement.alter.procedure");
            }
            case 59: {
                return Messages.getString("ASTSQLStatement.create.function");
            }
            case 159: {
                return Messages.getString("ASTSQLStatement.alter.function");
            }
            case 60: {
                return Messages.getString("ASTSQLStatement.create.event");
            }
            case 160: {
                return Messages.getString("ASTSQLStatement.alter.event");
            }
            case 61: {
                return Messages.getString("ASTSQLStatement.create.trigger");
            }
            case 62: {
                return Messages.getString("ASTSQLStatement.create.default");
            }
            case 63: {
                return Messages.getString("ASTSQLStatement.declare");
            }
            case 162: {
                return Messages.getString("ASTSQLStatement.call");
            }
            case 64: {
                return Messages.getString("ASTSQLStatement.begin");
            }
            case 163: {
                return Messages.getString("ASTSQLStatement.begin.transaction");
            }
            case 161: {
                return Messages.getString("ASTSQLStatement.alter.trigger");
            }
            case 65: {
                return Messages.getString("ASTSQLStatement.create.index");
            }
            case 165: {
                return Messages.getString("ASTSQLStatement.alter.index");
            }
        }
        return Messages.getString("ASTSQLStatement.others", node.getFirstToken().image.toUpperCase());
    }

    public static Image getImage(int type) {
        switch (type) {
            case 50: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlsql.gif");
            }
            case 51: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlselect.gif");
            }
            case 52: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlinsert.gif");
            }
            case 53: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqldelete.gif");
            }
            case 54: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlupdate.gif");
            }
            case 55: 
            case 155: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqldatabase.gif");
            }
            case 56: 
            case 156: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqltable.gif");
            }
            case 57: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlview.gif");
            }
            case 157: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlview.gif");
            }
            case 257: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlview.gif");
            }
            case 58: 
            case 158: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlprocedure.gif");
            }
            case 59: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlfunction.gif");
            }
            case 159: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlfunction.gif");
            }
            case 60: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlevent.gif");
            }
            case 160: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlevent.gif");
            }
            case 61: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqltrigger.gif");
            }
            case 161: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqltrigger.gif");
            }
            case 62: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqldefault.gif");
            }
            case 63: {
                return SQLImages.getImage("org.eclipse.datatools.sqltools.sqldatatype.gif");
            }
        }
        return SQLImages.getImage("org.eclipse.datatools.sqltools.sqlsql.gif");
    }
}

