/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.views.contentoutline;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SortAction
extends PropertyChangeUpdateAction {
    private TreeViewer treeViewer;

    public SortAction(TreeViewer viewer, IPreferenceStore store, String preferenceKey) {
        super(XMLUIMessages._UI_BUTTON_SORT, store, preferenceKey, false);
        this.setImageDescriptor(XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/sort.gif"));
        this.setToolTipText(this.getText());
        this.treeViewer = viewer;
        if (this.isChecked()) {
            this.treeViewer.setComparator((ViewerComparator)this.createComparator());
        }
    }

    private ViewerNodeComparator createComparator() {
        return new ViewerNodeComparator(this.getPreferenceStore());
    }

    public void update() {
        super.update();
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        if (this.isChecked()) {
            this.treeViewer.setComparator((ViewerComparator)this.createComparator());
        } else {
            this.treeViewer.setComparator(null);
        }
        this.treeViewer.setInput(this.treeViewer.getInput());
        this.treeViewer.setExpandedElements(expandedElements);
        this.treeViewer.getControl().setRedraw(true);
    }

    static class ViewerNodeComparator
    extends ViewerComparator {
        private int[] categories = new int[12];

        public ViewerNodeComparator(IPreferenceStore store) {
            this.initCategoryOrder(store);
        }

        private void initCategoryOrder(IPreferenceStore store) {
            String[] order = new String[]{StringUtils.unpack((String)store.getString("outline-behavior.element-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.attribute-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.text-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.cdata-section-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.entity-reference-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.entity-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.instruction-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.comment-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.document-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.document-type-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.document-fragment-node"))[0], StringUtils.unpack((String)store.getString("outline-behavior.notation-node"))[0]};
            int i = 0;
            while (i < order.length) {
                try {
                    this.categories[i] = Integer.parseInt(order[i]);
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }

        public int category(Object element) {
            if (element instanceof Node) {
                return this.categories[((Node)element).getNodeType() - 1];
            }
            return super.category(element);
        }

        public boolean isSorterProperty(Object element, String property) {
            if (element instanceof Element) {
                return ((Element)element).hasAttribute(property);
            }
            return super.isSorterProperty(element, property);
        }
    }
}

