/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.ui.internal;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class DTPUiTools {
    public static String createNewConnectionProfile() {
        NewCPWizard wizard = new NewCPWizard((ViewerFilter)new LocalViewerFilter(), null);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        LocalProfileListener listener = new LocalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        String newCPName = null;
        if (wizardDialog.open() == 0) {
            newCPName = listener.addedProfile.getName();
        }
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        return newCPName;
    }

    static class LocalProfileListener
    implements IProfileListener {
        IConnectionProfile addedProfile;

        LocalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.addedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }

    static class LocalViewerFilter
    extends ViewerFilter {
        private static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";

        LocalViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            CPWizardNode wizardNode = (CPWizardNode)element;
            IProfileWizardProvider wizardProvider = wizardNode.getProvider();
            if (wizardProvider instanceof IWizardCategoryProvider) {
                return false;
            }
            ICategory category = ConnectionProfileManager.getInstance().getProvider(((ProfileWizardProvider)wizardProvider).getProfile()).getCategory();
            while (category != null) {
                if (category.getId().equals(DATABASE_CATEGORY_ID)) {
                    return true;
                }
                category = category.getParent();
            }
            return false;
        }
    }
}

