/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.usagedata.internal.ui.Activator;
import org.eclipse.epp.usagedata.internal.ui.uploaders.AskUserUploader;
import org.eclipse.epp.usagedata.internal.ui.wizards.AskUserUploaderWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class SelectActionWizardPage
extends WizardPage {
    private static final String UDC_URL = "http://www.eclipse.org/org/usagedata/index.php";
    private static final String FAQ_URL = "http://www.eclipse.org/org/usagedata/faq.php";
    private static final int WIDTH_HINT = 500;
    private final AskUserUploader uploader;
    private Button neverUploadRadio;
    private Button dontUploadRadio;
    private Button uploadAlwaysRadio;
    private Button uploadNowRadio;

    public SelectActionWizardPage(AskUserUploader uploader) {
        super("wizardPage");
        this.uploader = uploader;
        this.setTitle("Usage Data Upload");
        this.setDescription("It's time to upload your usage data.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        FormText greeting = this.createFormText(composite, "<form><p>The Eclipse <a href=\"udc\">Usage Data Collector</a> (UDC) has been collecting data on how you have been using the workbench. It would now like to upload the data to a server at the Eclipse Foundation.</p><p>You can preview the data before it is uploaded on the <a href=\"preview\">Preview page</a>.</p><p>Questions about the UDC? Check out our <a href=\"faq\">Frequently Asked Questions</a>.</p></form>");
        greeting.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                if ("udc".equals(event.getHref())) {
                    SelectActionWizardPage.this.browseTo(SelectActionWizardPage.UDC_URL);
                } else if ("preview".equals(event.getHref())) {
                    ((AskUserUploaderWizard)SelectActionWizardPage.this.getWizard()).showPreviewPage();
                } else if ("faq".equals(event.getHref())) {
                    SelectActionWizardPage.this.browseTo(SelectActionWizardPage.FAQ_URL);
                }
            }
        });
        this.createSpacer(composite);
        this.createUploadNowRadio(composite);
        this.createSpacer(composite);
        this.createUploadAlwaysRadio(composite);
        this.createSpacer(composite);
        this.createDontUploadRadio(composite);
        this.createSpacer(composite);
        this.createNeverUploadRadio(composite);
        this.createSpacer(composite);
        FormText text = this.createFormText(composite, this.getTermsText());
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ((AskUserUploaderWizard)SelectActionWizardPage.this.getWizard()).showTermsPage();
            }
        });
        this.setControl((Control)composite);
    }

    private String getTermsText() {
        return "<form><p>You agree to provide this data under the Usage Data Collector <a href=\"terms\">Terms of Use</a>.</p></form>";
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData layoutData = new GridData();
        layoutData.heightHint = 5;
        spacer.setLayoutData((Object)layoutData);
    }

    private void createUploadNowRadio(Composite parent) {
        this.uploadNowRadio = this.createRadio(parent, "Upload now", 0);
        this.createDescriptionText(parent, "Upload the usage data now. Ask before uploading again.");
    }

    private void createUploadAlwaysRadio(Composite parent) {
        this.uploadAlwaysRadio = this.createRadio(parent, "Upload always", 1);
        this.createDescriptionText(parent, "Upload the usage data now. Don't ask next time; just do the upload in the background. Note that you can change this setting in the preferences.");
    }

    private void createDontUploadRadio(Composite parent) {
        this.dontUploadRadio = this.createRadio(parent, "Don't upload now", 2);
        this.createDescriptionText(parent, "Do not upload usage data at this time. You will be asked to do the upload later.");
    }

    private void createNeverUploadRadio(Composite parent) {
        this.neverUploadRadio = this.createRadio(parent, "Turn UDC feature off", 3);
        this.createDescriptionText(parent, "Stop collecting data. The UDC will be turned off and data will never be uploaded.");
    }

    private Button createRadio(Composite parent, String label, final int action) {
        Button radio = new Button(parent, 16);
        radio.setText(label);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionWizardPage.this.uploader.setAction(action);
                SelectActionWizardPage.this.getContainer().updateButtons();
            }
        });
        radio.setSelection(this.uploader.getAction() == action);
        return radio;
    }

    private void createDescriptionText(Composite parent, String string) {
        this.createText(parent, string, 25);
    }

    private void createText(Composite parent, String string, int indent) {
        Label text = new Label(parent, 64);
        text.setText(string);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = indent;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
    }

    private FormText createFormText(Composite parent, String string) {
        FormText text = new FormText(parent, 64);
        text.setText(string, true, true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
        return text;
    }

    public boolean isPageComplete() {
        if (this.uploadAlwaysRadio.getSelection()) {
            return true;
        }
        if (this.uploadNowRadio.getSelection()) {
            return true;
        }
        if (this.neverUploadRadio.getSelection()) {
            return true;
        }
        return this.dontUploadRadio.getSelection();
    }

    private void browseTo(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.epp.usagedata.ui", "Error opening browser", (Throwable)e));
        }
    }
}

