/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClasspathHelper {
    public static final String LEGACY_METADATA_FILE_NAME = ".settings/org.eclipse.jst.common.project.facet.core.prefs";
    private static final Object SYSTEM_OWNER = new Object();
    private static final String OWNER_PROJECT_FACETS_ATTR = "owner.project.facets";

    private ClasspathHelper() {
    }

    public static boolean addClasspathEntries(IProject project, IProjectFacetVersion fv) throws CoreException {
        IClasspathProvider cpprov;
        List<IClasspathEntry> cpentries;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        IRuntime runtime = fproj.getPrimaryRuntime();
        if (runtime != null && (cpentries = (cpprov = (IClasspathProvider)runtime.getAdapter(IClasspathProvider.class)).getClasspathEntries(fv)) != null) {
            ClasspathHelper.addClasspathEntries(project, fv, cpentries);
            return true;
        }
        return false;
    }

    public static void addClasspathEntries(IProject project, IProjectFacetVersion fv, List<IClasspathEntry> cpentries) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ClasspathHelper.convertLegacyMetadata(jproj);
        List<IClasspathEntry> cp = ClasspathHelper.getProjectClasspath(jproj);
        for (IClasspathEntry cpe : cpentries) {
            IClasspathEntry annotatedEntry;
            IClasspathEntry existingClasspathEntry = null;
            for (IClasspathEntry x : cp) {
                if (!x.getPath().equals((Object)cpe.getPath())) continue;
                existingClasspathEntry = x;
                break;
            }
            Set<Object> owners = ClasspathHelper.getOwners(existingClasspathEntry);
            owners.add(fv);
            if (existingClasspathEntry != null) {
                annotatedEntry = ClasspathHelper.setOwners(existingClasspathEntry, owners);
                int existingIndex = cp.indexOf(existingClasspathEntry);
                cp.set(existingIndex, annotatedEntry);
                continue;
            }
            annotatedEntry = ClasspathHelper.setOwners(cpe, owners);
            cp.add(annotatedEntry);
        }
        ClasspathHelper.setProjectClasspath(jproj, cp);
    }

    public static void removeClasspathEntries(IProject project, IProjectFacetVersion fv) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ClasspathHelper.convertLegacyMetadata(jproj);
        List<IClasspathEntry> cp = ClasspathHelper.getProjectClasspath(jproj);
        boolean cpchanged = false;
        ListIterator<IClasspathEntry> itr = cp.listIterator();
        while (itr.hasNext()) {
            IClasspathEntry cpe = itr.next();
            Set<Object> owners = ClasspathHelper.getOwners(cpe);
            if (!owners.remove(fv)) continue;
            if (owners.size() == 0) {
                itr.remove();
            } else {
                itr.set(ClasspathHelper.setOwners(cpe, owners));
            }
            cpchanged = true;
        }
        if (cpchanged) {
            ClasspathHelper.setProjectClasspath(jproj, cp);
        }
    }

    private static List<IClasspathEntry> getProjectClasspath(IJavaProject jproj) throws CoreException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            result.add(cpe);
            ++n2;
        }
        return result;
    }

    private static void setProjectClasspath(IJavaProject jproj, List<IClasspathEntry> cp) throws CoreException {
        jproj.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
    }

    private static String encodeOwnersString(Set<Object> owners) {
        StringBuilder buf = new StringBuilder();
        for (Object owner : owners) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            if (owner == SYSTEM_OWNER) {
                buf.append("#system#");
                continue;
            }
            IProjectFacetVersion fv = (IProjectFacetVersion)owner;
            buf.append(fv.getProjectFacet().getId());
            buf.append(':');
            buf.append(fv.getVersionString());
        }
        return buf.toString();
    }

    private static Set<Object> decodeOwnersString(String str) {
        HashSet<Object> owners = new HashSet<Object>();
        String[] split = str.split(";");
        int j = 0;
        while (j < split.length) {
            String segment = split[j];
            if (segment.equals("#system#")) {
                owners.add(SYSTEM_OWNER);
            } else {
                IProjectFacetVersion fv = ClasspathHelper.decodeFacetVersion(segment);
                owners.add(fv);
            }
            ++j;
        }
        return owners;
    }

    private static IProjectFacetVersion decodeFacetVersion(String str) {
        int colon = str.indexOf(58);
        String id = str.substring(0, colon);
        String ver = str.substring(colon + 1);
        return ProjectFacetsManager.getProjectFacet((String)id).getVersion(ver);
    }

    private static Set<Object> getOwners(IClasspathEntry cpe) {
        HashSet<Object> owners = new HashSet<Object>();
        if (cpe != null) {
            IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attr = iClasspathAttributeArray[n2];
                if (attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                    owners.addAll(ClasspathHelper.decodeOwnersString(attr.getValue()));
                    break;
                }
                ++n2;
            }
            if (owners.isEmpty()) {
                owners.add(SYSTEM_OWNER);
            }
        }
        return owners;
    }

    private static IClasspathEntry setOwners(IClasspathEntry cpe, Set<Object> owners) {
        if (owners.size() == 1 && owners.iterator().next() == SYSTEM_OWNER) {
            owners.clear();
        }
        String ownersString = owners.size() == 0 ? null : ClasspathHelper.encodeOwnersString(owners);
        return ClasspathHelper.setOwners(cpe, ownersString);
    }

    private static IClasspathEntry setOwners(IClasspathEntry cpe, String owners) {
        ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if (!attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                attrs.add(attr);
            }
            ++n2;
        }
        if (owners != null) {
            attrs.add(JavaCore.newClasspathAttribute((String)OWNER_PROJECT_FACETS_ATTR, (String)owners));
        }
        return new ClasspathEntry(cpe.getContentKind(), cpe.getEntryKind(), cpe.getPath(), cpe.getInclusionPatterns(), cpe.getExclusionPatterns(), cpe.getSourceAttachmentPath(), cpe.getSourceAttachmentRootPath(), cpe.getOutputLocation(), cpe.isExported(), cpe.getAccessRules(), cpe.combineAccessRules(), attrs.toArray(new IClasspathAttribute[attrs.size()]));
    }

    private static void convertLegacyMetadata(IJavaProject jproj) throws CoreException {
        IProject project = jproj.getProject();
        IFile legacyMetadataFile = project.getFile(LEGACY_METADATA_FILE_NAME);
        if (legacyMetadataFile.exists()) {
            String[] keys;
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
            Preferences root = pluginRoot.node("classpath.helper");
            HashMap<Path, String> metadata = new HashMap<Path, String>();
            try {
                keys = root.childrenNames();
            }
            catch (BackingStoreException e) {
                throw new CoreException(FacetCorePlugin.createErrorStatus(e.getMessage(), (Exception)((Object)e)));
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Preferences node = root.node(key);
                String owners = node.get("owners", null);
                if (owners != null) {
                    metadata.put(new Path(key.replaceAll("::", "/")), owners);
                }
                ++n2;
            }
            if (!metadata.isEmpty()) {
                List<IClasspathEntry> cp = ClasspathHelper.getProjectClasspath(jproj);
                boolean cpchanged = false;
                ListIterator<IClasspathEntry> itr = cp.listIterator();
                while (itr.hasNext()) {
                    IClasspathEntry cpe = itr.next();
                    String owners = (String)metadata.get(cpe.getPath());
                    if (owners == null) continue;
                    itr.set(ClasspathHelper.setOwners(cpe, owners));
                    cpchanged = true;
                }
                if (cpchanged) {
                    ClasspathHelper.setProjectClasspath(jproj, cp);
                }
            }
            legacyMetadataFile.delete(true, null);
        }
    }
}

