/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.p2.ui.provisioner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.DownloadPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.p2.ui.Activator;
import org.eclipse.pde.internal.p2.ui.provisioner.P2TargetProvisionerWizardPage;
import org.eclipse.pde.internal.p2.ui.provisioner.ProvisionerMessages;
import org.eclipse.pde.ui.IProvisionerWizard;
import org.eclipse.swt.widgets.Shell;

public class P2TargetProvisionerWizard
extends Wizard
implements IProvisionerWizard {
    private P2TargetProvisionerWizardPage fSelectIUPage;
    private File[] fLocations;
    private static final String PROFILE_ID = "TEMP_TARGET_PROVISIONER_PROFILE";
    private static final String DIALOG_SETTINGS_SECTION = "P2TargetProvisionerWizardSettings";

    public P2TargetProvisionerWizard() {
        this.setWindowTitle(ProvisionerMessages.P2TargetProvisionerWizard_1);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor((String)"wizban/install_wiz.gif"));
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fSelectIUPage = new P2TargetProvisionerWizardPage("Select IU Page");
        this.fSelectIUPage.setTitle(ProvisionerMessages.P2TargetProvisionerWizard_1);
        this.fSelectIUPage.setDescription(ProvisionerMessages.P2TargetProvisionerWizard_2);
        this.addPage((IWizardPage)this.fSelectIUPage);
        super.addPages();
    }

    public boolean canFinish() {
        return this.fSelectIUPage.isPageComplete();
    }

    public boolean performFinish() {
        this.fSelectIUPage.saveWidgetState();
        DownloadIUOperation op = new DownloadIUOperation(this.fSelectIUPage.getDownloadLocation(true), this.fSelectIUPage.isClearContentsBeforeDownloading(), this.fSelectIUPage.getUnits());
        try {
            this.fLocations = new File[0];
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                ErrorDialog.openError((Shell)this.getShell(), (String)ProvisionerMessages.P2TargetProvisionerWizard_3, (String)e.getTargetException().getMessage(), (IStatus)(e.getTargetException() instanceof CoreException ? ((CoreException)e.getTargetException()).getStatus() : new Status(4, Activator.getUniqueIdentifier(), e.getTargetException().getMessage())));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)ProvisionerMessages.P2TargetProvisionerWizard_3, (String)e.getMessage(), (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
            return false;
        }
        catch (InterruptedException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)ProvisionerMessages.P2TargetProvisionerWizard_7, (String)e.getMessage(), (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            return false;
        }
    }

    public File[] getLocations() {
        return this.fLocations;
    }

    private class DownloadIUOperation
    implements IRunnableWithProgress {
        private File fInstallDir;
        private boolean fClearContents;
        private IInstallableUnit[] fUnits;

        public DownloadIUOperation(File installDir, boolean clearContentsBeforeDownload, IInstallableUnit[] units) {
            this.fInstallDir = installDir;
            this.fClearContents = clearContentsBeforeDownload;
            this.fUnits = units;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            monitor.beginTask(ProvisionerMessages.P2TargetProvisionerWizard_9, 4);
            if (this.fInstallDir != null && this.fInstallDir.isDirectory()) {
                block13: {
                    if (this.fClearContents) {
                        File[] contents = this.fInstallDir.listFiles();
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, contents.length, 4);
                        subMonitor.setTaskName(ProvisionerMessages.P2TargetProvisionerWizard_10);
                        int i = 0;
                        while (i < contents.length) {
                            this.deleteDir(contents[i]);
                            subMonitor.worked(1);
                            ++i;
                        }
                        subMonitor.done();
                    } else {
                        monitor.worked(1);
                    }
                    try {
                        try {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("org.eclipse.equinox.p2.installFolder", this.fInstallDir.toString());
                            properties.put("org.eclipse.equinox.p2.cache", this.fInstallDir.toString());
                            ProvisioningUtil.removeProfile((String)P2TargetProvisionerWizard.PROFILE_ID, (IProgressMonitor)monitor);
                            IProfile newProfile = ProvisioningUtil.addProfile((String)P2TargetProvisionerWizard.PROFILE_ID, properties, (IProgressMonitor)monitor);
                            monitor.worked(1);
                            ProfileChangeRequest request = new ProfileChangeRequest(newProfile);
                            request.addInstallableUnits(this.fUnits);
                            ProvisioningPlan plan = ProvisioningUtil.getProvisioningPlan((ProfileChangeRequest)request, (ProvisioningContext)new ProvisioningContext(), (IProgressMonitor)monitor);
                            monitor.worked(1);
                            IStatus result = ProvisioningUtil.performProvisioningPlan((ProvisioningPlan)plan, (PhaseSet)new DownloadPhaseSet(), (IProfile)newProfile, (IProgressMonitor)monitor);
                            if (result.isOK()) {
                                P2TargetProvisionerWizard.this.fLocations = new File[]{this.fInstallDir};
                                break block13;
                            }
                            throw new InvocationTargetException((Throwable)new CoreException(result));
                        }
                        catch (ProvisionException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ProvisioningUtil.removeProfile((String)P2TargetProvisionerWizard.PROFILE_ID, (IProgressMonitor)monitor);
                        }
                        catch (ProvisionException provisionException) {}
                        throw throwable;
                    }
                }
                try {
                    ProvisioningUtil.removeProfile((String)P2TargetProvisionerWizard.PROFILE_ID, (IProgressMonitor)monitor);
                }
                catch (ProvisionException provisionException) {}
            }
            monitor.done();
        }

        private void deleteDir(File dir) {
            if (dir.exists()) {
                File[] children;
                if (dir.isDirectory() && (children = dir.listFiles()) != null) {
                    int i = 0;
                    while (i < children.length) {
                        this.deleteDir(children[i]);
                        ++i;
                    }
                }
                dir.delete();
            }
        }
    }
}

