/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableJoinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.DefineJoinTypeDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SearchConditionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class DefineJoinTypeAction
extends Action {
    SQLDomainModel domainModel;
    SQLQueryObject joinSource;

    public DefineJoinTypeAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_SPECIFY_JOIN_TYPE);
        this.domainModel = domainModel;
    }

    public void setSQLJoin(SQLQueryObject join) {
        this.joinSource = join;
    }

    public void run() {
        int joinType = 0;
        if (this.joinSource instanceof TableJoined) {
            joinType = ((TableJoined)this.joinSource).getJoinOperator().getValue();
        }
        DefineJoinTypeDialog dialog = new DefineJoinTypeDialog(Display.getCurrent().getActiveShell(), joinType, this.domainModel);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int value = dialog.open();
        if (value == 0) {
            int newType = dialog.getJoinType();
            if (this.joinSource instanceof TableJoined) {
                ((TableJoined)this.joinSource).setJoinOperator(TableJoinedOperator.get((int)newType));
            } else if (this.joinSource instanceof QuerySearchCondition) {
                QuerySearchCondition condition = (QuerySearchCondition)this.joinSource;
                QuerySelect querySelect = condition.getQuerySelectWhere();
                EList fromClause = querySelect.getFromClause();
                List predicates = SearchConditionHelper.getAllPredicates(condition);
                Iterator itr = predicates.iterator();
                while (itr.hasNext()) {
                    Predicate predicate = (Predicate)itr.next();
                    if (!(predicate instanceof PredicateBasic)) continue;
                    PredicateBasic predicateBasic = (PredicateBasic)predicate;
                    QueryValueExpression leftExpr = predicateBasic.getLeftValueExpr();
                    QueryValueExpression rightExpr = predicateBasic.getRightValueExpr();
                    ValueExpressionColumn sourceCol = null;
                    ValueExpressionColumn targetCol = null;
                    TableExpression sourceTbl = null;
                    TableExpression targetTbl = null;
                    if (leftExpr instanceof ValueExpressionColumn) {
                        sourceCol = (ValueExpressionColumn)leftExpr;
                        sourceTbl = sourceCol.getTableExpr();
                    }
                    if (rightExpr instanceof ValueExpressionColumn) {
                        targetCol = (ValueExpressionColumn)rightExpr;
                        targetTbl = targetCol.getTableExpr();
                    }
                    if (targetCol == null || sourceCol == null || sourceTbl == null || targetTbl == null) continue;
                    condition = SearchConditionHelper.removePredicateFromCondition(predicate, condition);
                    JoinHelper.addJoin((List)fromClause, (TableExpression)sourceTbl, (TableExpression)targetTbl, (ValueExpressionColumn)sourceCol, (ValueExpressionColumn)targetCol, (int)newType);
                }
                this.setWhereClauseInQuerySelect(querySelect, condition);
            }
            QueryStatement stmt = this.domainModel.getSQLStatement();
            if (stmt instanceof QuerySelectStatement) {
                SelectHelper.refresh((QuerySelectStatement)stmt);
            }
        }
    }

    private void setWhereClauseInQuerySelect(QuerySelect querySelect, QuerySearchCondition condition) {
        if (condition instanceof PredicateBasic) {
            PredicateBasic sqlPredicate = (PredicateBasic)condition;
            if (sqlPredicate.getRightValueExpr() == null && sqlPredicate.getLeftValueExpr() == null) {
                querySelect.setWhereClause(null);
            } else {
                querySelect.setWhereClause(condition);
            }
        } else if (condition instanceof SearchConditionCombined) {
            SearchConditionCombined grp = (SearchConditionCombined)condition;
            if (grp.getLeftCondition() == null && grp.getRightCondition() == null) {
                querySelect.setWhereClause(null);
            } else {
                querySelect.setWhereClause(condition);
            }
        } else if (condition instanceof SearchConditionNested) {
            QuerySearchCondition cond = ((SearchConditionNested)condition).getNestedCondition();
            this.setWhereClauseInQuerySelect(querySelect, cond);
        } else {
            querySelect.setWhereClause(condition);
        }
    }
}

