/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.win32;

import java.io.File;
import java.util.Vector;
import org.eclipse.compare.internal.win32.Activator;
import org.eclipse.compare.internal.win32.CompareWin32Messages;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class WordComparison {
    private final OleFrame frame;
    private OleClientSite site;
    private boolean inplace;
    private OleAutomation document;

    public WordComparison(Composite composite) {
        this.frame = new OleFrame(composite, 0);
    }

    private static Variant invoke(OleAutomation auto, String command) {
        return auto.invoke(WordComparison.property(auto, command), new Variant[0]);
    }

    private static Variant invoke(OleAutomation auto, String command, int value) {
        return auto.invoke(WordComparison.property(auto, command), new Variant[]{new Variant(value)});
    }

    private static Variant invoke(OleAutomation auto, String command, String value) {
        return auto.invoke(WordComparison.property(auto, command), new Variant[]{new Variant(value)});
    }

    private static Variant getVariantProperty(OleAutomation auto, String name) {
        Variant varResult = auto.getProperty(WordComparison.property(auto, name));
        if (varResult != null && varResult.getType() != 0) {
            return varResult;
        }
        throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_0, (Object)name));
    }

    private static OleAutomation getAutomationProperty(OleAutomation auto, String name) {
        Variant varResult = WordComparison.getVariantProperty(auto, name);
        try {
            OleAutomation automation = varResult.getAutomation();
            if (automation != null) {
                OleAutomation oleAutomation = automation;
                return oleAutomation;
            }
        }
        finally {
            varResult.dispose();
        }
        throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_1, (Object)name));
    }

    private static OleAutomation getAutomationResult(OleAutomation auto, String command, int value) {
        Variant varResult = WordComparison.invoke(auto, command, value);
        if (varResult != null) {
            try {
                OleAutomation result = varResult.getAutomation();
                if (result != null) {
                    OleAutomation oleAutomation = result;
                    return oleAutomation;
                }
            }
            finally {
                varResult.dispose();
            }
        }
        throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_2, (Object)command, (Object)Integer.toString(value)));
    }

    private static OleAutomation getAutomationResult(OleAutomation auto, String command, String value) {
        Variant varResult = WordComparison.invoke(auto, command, value);
        if (varResult != null) {
            try {
                OleAutomation result = varResult.getAutomation();
                if (result != null) {
                    OleAutomation oleAutomation = result;
                    return oleAutomation;
                }
            }
            finally {
                varResult.dispose();
            }
        }
        throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_3, (Object)command, (Object)value));
    }

    private static int property(OleAutomation auto, String name) {
        int[] ids = auto.getIDsOfNames(new String[]{name});
        if (ids == null) {
            throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_4, (Object)name));
        }
        return ids[0];
    }

    private static boolean setProperty(OleAutomation auto, String name, boolean value) {
        return auto.setProperty(WordComparison.property(auto, name), new Variant(value));
    }

    public void openDocument(String filePath, boolean inplace) throws SWTException {
        this.resetSite(inplace ? filePath : null);
        if (inplace) {
            this.site.doVerb(-1);
        } else {
            OleAutomation application = this.createApplication();
            try {
                this.document = this.openDocument(application, filePath);
                this.setDocumentVisible(this.document, true);
            }
            finally {
                application.dispose();
            }
        }
    }

    public void createWorkingCopy(String baseDocument, String revisedDocument, String workingCopy) throws SWTException {
        this.resetSite(null);
        OleAutomation application = this.createApplication();
        try {
            OleAutomation document = this.openDocument(application, revisedDocument);
            try {
                this.setDocumentVisible(document, false);
                this.compareDocument(document, baseDocument, revisedDocument);
                OleAutomation activeDocument = this.getActiveDocument(application);
                try {
                    Variant varResult = WordComparison.invoke(activeDocument, "SaveAs", workingCopy);
                    if (varResult == null) {
                        throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_6, (Object)workingCopy));
                    }
                    varResult.dispose();
                }
                finally {
                    try {
                        this.closeDocument(activeDocument);
                    }
                    finally {
                        activeDocument.dispose();
                    }
                }
            }
            finally {
                try {
                    this.closeDocument(document);
                }
                finally {
                    document.dispose();
                }
            }
        }
        finally {
            application.dispose();
        }
    }

    private void closeDocument(OleAutomation document) {
        Variant varResult = WordComparison.invoke(document, "Close");
        if (varResult != null) {
            varResult.dispose();
        }
    }

    private void compareDocument(OleAutomation document, String baseDocument, String revisedDocument) {
        Variant varResult = WordComparison.invoke(document, "Compare", baseDocument);
        if (varResult == null) {
            throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_9, (Object)baseDocument, (Object)revisedDocument));
        }
        varResult.dispose();
    }

    private boolean getDocumentDirty(OleAutomation document) {
        Variant variantProperty;
        if (document != null && (variantProperty = WordComparison.getVariantProperty(document, "Saved")) != null) {
            try {
                boolean bl = !variantProperty.getBoolean();
                return bl;
            }
            finally {
                variantProperty.dispose();
            }
        }
        return false;
    }

    private void setDocumentVisible(OleAutomation document, boolean visible) {
        OleAutomation windows = WordComparison.getAutomationProperty(document, "Windows");
        try {
            OleAutomation window = WordComparison.getAutomationResult(windows, "Item", 1);
            try {
                WordComparison.setProperty(window, "Visible", visible);
            }
            finally {
                window.dispose();
            }
        }
        finally {
            windows.dispose();
        }
    }

    private OleAutomation openDocument(OleAutomation application, String doc) {
        OleAutomation documents = WordComparison.getAutomationProperty(application, "Documents");
        try {
            OleAutomation document = WordComparison.getAutomationResult(documents, "Open", doc);
            if (document == null) {
                throw new SWTException(NLS.bind((String)CompareWin32Messages.WordComparison_16, (Object)doc));
            }
            OleAutomation oleAutomation = document;
            return oleAutomation;
        }
        finally {
            documents.dispose();
        }
    }

    private OleAutomation getActiveDocument(OleAutomation application) {
        return WordComparison.getAutomationProperty(application, "ActiveDocument");
    }

    private OleAutomation createApplication() {
        return new OleAutomation(this.site);
    }

    private void resetSite(String filePath) {
        if (this.site != null && !this.site.isDisposed()) {
            this.disposeSite();
        }
        this.inplace = filePath != null;
        this.site = this.inplace ? new OleClientSite((Composite)this.frame, 0, "Word.Document", new File(filePath)) : new OleClientSite((Composite)this.frame, 0, "Word.Application");
    }

    private void disposeSite() {
        block13: {
            if (this.document != null) {
                try {
                    this.closeDocument(this.document);
                }
                catch (SWTException e) {
                    Activator.log(e);
                }
                this.document.dispose();
                this.document = null;
                OleAutomation application = this.createApplication();
                try {
                    OleAutomation documents = WordComparison.getAutomationProperty(application, "Documents");
                    try {
                        Variant property = WordComparison.getVariantProperty(documents, "Count");
                        if (property == null) break block13;
                        try {
                            Variant result;
                            if (property.getLong() == 0L && (result = WordComparison.invoke(application, "Quit")) != null) {
                                result.dispose();
                            }
                        }
                        finally {
                            property.dispose();
                        }
                    }
                    finally {
                        documents.dispose();
                    }
                }
                finally {
                    application.dispose();
                }
            }
        }
        this.site.dispose();
        this.site = null;
    }

    public void saveAsDocument(String doc) {
        if (this.site == null || this.site.isDisposed()) {
            return;
        }
        if (this.inplace) {
            this.site.deactivateInPlaceClient();
            this.site.save(new File(doc), true);
            this.site.doVerb(-1);
        } else if (this.document != null) {
            try {
                Variant variant = WordComparison.invoke(this.document, "SaveAs", doc);
                if (variant != null) {
                    variant.dispose();
                }
            }
            catch (SWTException sWTException) {}
        }
    }

    public OleFrame getFrame() {
        return this.frame;
    }

    public void dispose() {
        try {
            this.disposeSite();
        }
        finally {
            if (!this.frame.isDisposed()) {
                this.frame.dispose();
            }
        }
    }

    public boolean isDirty() {
        return this.inplace && this.site != null && !this.site.isDisposed() && this.site.isDirty() || !this.inplace && this.getDocumentDirty(this.document);
    }

    protected void initializeWorkbenchMenus(IWorkbenchWindow window) {
        if (this.frame == null || this.frame.isDisposed()) {
            return;
        }
        Shell shell = this.frame.getShell();
        Menu menuBar = shell.getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)shell, 2);
            shell.setMenuBar(menuBar);
        }
        MenuItem[] windowMenu = new MenuItem[1];
        MenuItem[] fileMenu = new MenuItem[1];
        Vector<MenuItem> containerItems = new Vector<MenuItem>();
        int i = 0;
        while (i < menuBar.getItemCount()) {
            MenuItem item = menuBar.getItem(i);
            String id = "";
            if (item.getData() instanceof IMenuManager) {
                id = ((IMenuManager)item.getData()).getId();
            }
            if (id.equals("file")) {
                fileMenu[0] = item;
            } else if (id.equals("window")) {
                windowMenu[0] = item;
            } else if (window.isApplicationMenu(id)) {
                containerItems.addElement(item);
            }
            ++i;
        }
        Object[] containerMenu = new MenuItem[containerItems.size()];
        containerItems.copyInto(containerMenu);
        this.frame.setFileMenus(fileMenu);
        this.frame.setContainerMenus((MenuItem[])containerMenu);
        this.frame.setWindowMenus(windowMenu);
    }

    public boolean isInplace() {
        return this.inplace;
    }

    public boolean isOpen() {
        return this.site != null && !this.site.isDisposed();
    }

    public void close() {
        if (this.isOpen()) {
            this.disposeSite();
        }
    }
}

