/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CleanDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "CleanDialogSettings";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String TOGGLE_SELECTED = "TOGGLE_SELECTED";
    private static final String BUILD_NOW = "BUILD_NOW";
    private static final String BUILD_ALL = "BUILD_ALL";
    private Button allButton;
    private Button selectedButton;
    private Button buildNowButton;
    private Button globalBuildButton;
    private Button projectBuildButton;
    private CheckboxTableViewer projectNames;
    private Object[] selection;
    private IWorkbenchWindow window;

    private static String getQuestion() {
        boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (autoBuilding) {
            return IDEWorkbenchMessages.CleanDialog_buildCleanAuto;
        }
        return IDEWorkbenchMessages.CleanDialog_buildCleanManual;
    }

    public CleanDialog(IWorkbenchWindow window, IProject[] selection) {
        super(window.getShell(), IDEWorkbenchMessages.CleanDialog_title, null, CleanDialog.getQuestion(), 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.window = window;
        this.selection = selection;
        if (this.selection == null) {
            this.selection = new Object[0];
        }
    }

    protected void buttonPressed(int buttonId) {
        final boolean cleanAll = this.allButton.getSelection();
        final boolean buildAll = this.buildNowButton != null && this.buildNowButton.getSelection();
        final boolean globalBuild = this.globalBuildButton != null && this.globalBuildButton.getSelection();
        super.buttonPressed(buttonId);
        if (buttonId != 0) {
            return;
        }
        BuildUtilities.saveEditors(null);
        WorkspaceJob cleanJob = new WorkspaceJob(IDEWorkbenchMessages.CleanDialog_taskName){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CleanDialog.this.doClean(cleanAll, monitor);
                if (buildAll) {
                    if (globalBuild) {
                        GlobalBuildAction build = new GlobalBuildAction(CleanDialog.this.window, 10);
                        build.doBuild();
                    } else {
                        IProject[] projects = new IProject[CleanDialog.this.selection.length];
                        int i = 0;
                        while (i < CleanDialog.this.selection.length) {
                            projects[i] = (IProject)CleanDialog.this.selection[i];
                            ++i;
                        }
                        ProjectSubsetBuildAction projectBuild = new ProjectSubsetBuildAction((IShellProvider)CleanDialog.this.window, 10, projects);
                        projectBuild.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        cleanJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        cleanJob.setUser(true);
        cleanJob.schedule();
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanDialog.this.updateEnablement();
            }
        };
        IDialogSettings settings = this.getDialogSettings(DIALOG_SETTINGS_SECTION);
        boolean selectSelectedButton = settings.getBoolean(TOGGLE_SELECTED);
        this.allButton = new Button(area, 16);
        this.allButton.setText(IDEWorkbenchMessages.CleanDialog_cleanAllButton);
        this.allButton.setSelection(!selectSelectedButton);
        this.allButton.addSelectionListener((SelectionListener)updateEnablement);
        this.selectedButton = new Button(area, 16);
        this.selectedButton.setText(IDEWorkbenchMessages.CleanDialog_cleanSelectedButton);
        this.selectedButton.setSelection(selectSelectedButton);
        this.selectedButton.addSelectionListener((SelectionListener)updateEnablement);
        this.createProjectSelectionTable(area);
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            this.buildNowButton = new Button(parent, 32);
            this.buildNowButton.setText(IDEWorkbenchMessages.CleanDialog_buildNowButton);
            String buildNow = settings.get(BUILD_NOW);
            this.buildNowButton.setSelection(buildNow == null || Boolean.valueOf(buildNow) != false);
            this.buildNowButton.setLayoutData((Object)new GridData(32));
            this.buildNowButton.addSelectionListener((SelectionListener)updateEnablement);
            this.globalBuildButton = new Button(parent, 16);
            this.globalBuildButton.setText(IDEWorkbenchMessages.CleanDialog_globalBuildButton);
            String buildAll = settings.get(BUILD_ALL);
            this.globalBuildButton.setSelection(buildAll == null || Boolean.valueOf(buildAll) != false);
            GridData data = new GridData(32);
            data.horizontalIndent = 10;
            this.globalBuildButton.setLayoutData((Object)data);
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
            this.projectBuildButton = new Button(parent, 16);
            this.projectBuildButton.setText(IDEWorkbenchMessages.CleanDialog_buildSelectedProjectsButton);
            this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
            data = new GridData(32);
            data.horizontalIndent = 10;
            this.projectBuildButton.setLayoutData((Object)data);
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
            SelectionAdapter buildRadioSelected = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanDialog.this.updateBuildRadioEnablement();
                }
            };
            this.globalBuildButton.addSelectionListener((SelectionListener)buildRadioSelected);
            this.projectBuildButton.addSelectionListener((SelectionListener)buildRadioSelected);
        }
        this.projectNames.getTable().setEnabled(selectSelectedButton);
        return area;
    }

    private void createProjectSelectionTable(Composite radioGroup) {
        this.projectNames = CheckboxTableViewer.newCheckList((Composite)radioGroup, (int)2048);
        this.projectNames.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.projectNames.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectNames.setComparator((ViewerComparator)new ResourceComparator(1));
        this.projectNames.addFilter(new ViewerFilter(){
            private final IProject[] projectHolder = new IProject[1];

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IProject)) {
                    return false;
                }
                IProject project = (IProject)element;
                if (!project.isAccessible()) {
                    return false;
                }
                this.projectHolder[0] = project;
                return BuildUtilities.isEnabled(this.projectHolder, 15);
            }
        });
        this.projectNames.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.widthHint = 200;
        data.heightHint = 200;
        this.projectNames.getTable().setLayoutData((Object)data);
        this.projectNames.setCheckedElements(this.selection);
        this.projectNames.getTable().setEnabled(this.selectedButton.getSelection());
        this.projectNames.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CleanDialog.this.selection = CleanDialog.this.projectNames.getCheckedElements();
                CleanDialog.this.updateEnablement();
            }
        });
    }

    protected void doClean(boolean cleanAll, IProgressMonitor monitor) throws CoreException {
        if (cleanAll) {
            ResourcesPlugin.getWorkspace().build(15, monitor);
        } else {
            try {
                monitor.beginTask(IDEWorkbenchMessages.CleanDialog_taskName, this.selection.length);
                int i = 0;
                while (i < this.selection.length) {
                    ((IProject)this.selection[i]).build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void updateEnablement() {
        this.projectNames.getTable().setEnabled(this.selectedButton.getSelection());
        boolean enabled = this.allButton.getSelection() || this.selection.length > 0;
        this.getButton(0).setEnabled(enabled);
        if (this.globalBuildButton != null) {
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
        if (this.projectBuildButton != null) {
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
    }

    protected void updateBuildRadioEnablement() {
        this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
    }

    public boolean close() {
        this.persistDialogSettings(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return p != null ? p : super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return this.getInitialSize(DIALOG_SETTINGS_SECTION, p);
    }

    public Point getInitialLocation(String dialogSettingsSectionName) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_ORIGIN_X);
            int y = settings.getInt(DIALOG_ORIGIN_Y);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IDialogSettings getDialogSettings(String dialogSettingsSectionName) {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(dialogSettingsSectionName);
        if (section == null) {
            section = settings.addNewSection(dialogSettingsSectionName);
        }
        return section;
    }

    private void persistDialogSettings(Shell shell, String dialogSettingsSectionName) {
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        settings.put(DIALOG_ORIGIN_X, shellLocation.x);
        settings.put(DIALOG_ORIGIN_Y, shellLocation.y);
        settings.put(DIALOG_WIDTH, shellSize.x);
        settings.put(DIALOG_HEIGHT, shellSize.y);
        if (this.buildNowButton != null) {
            settings.put(BUILD_NOW, this.buildNowButton.getSelection());
        }
        if (this.globalBuildButton != null) {
            settings.put(BUILD_ALL, this.globalBuildButton.getSelection());
        }
        settings.put(TOGGLE_SELECTED, this.selectedButton.getSelection());
    }

    private Point getInitialSize(String dialogSettingsSectionName, Point initialSize) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_WIDTH);
            int y = settings.getInt(DIALOG_HEIGHT);
            return new Point(Math.max(x, initialSize.x), Math.max(y, initialSize.y));
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private class ProjectSubsetBuildAction
    extends BuildAction {
        private IProject[] projectsToBuild = new IProject[0];

        public ProjectSubsetBuildAction(IShellProvider shellProvider, int type, IProject[] projects) {
            super(shellProvider, type);
            this.projectsToBuild = projects;
        }

        protected List getSelectedResources() {
            return Arrays.asList(this.projectsToBuild);
        }
    }
}

