/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Set;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class PathVariableDialog
extends TitleAreaDialog {
    private Button okButton;
    private Label variableNameLabel;
    private Label variableValueLabel;
    private Text variableNameField;
    private Text variableValueField;
    private Button fileButton;
    private Button folderButton;
    private int type;
    private int variableType;
    private String variableName;
    private String variableValue;
    private String originalName;
    private boolean newVariable;
    private IPathVariableManager pathVariableManager;
    private Set namesInUse;
    private int validationStatus;
    private String validationMessage;
    private boolean nameEntered = false;
    private boolean locationEntered = false;
    private final String standardMessage;
    public static final int NEW_VARIABLE = 1;
    public static final int EXISTING_VARIABLE = 2;

    public PathVariableDialog(Shell parentShell, int type, int variableType, IPathVariableManager pathVariableManager, Set namesInUse) {
        super(parentShell);
        this.type = type;
        this.newVariable = type == 1;
        this.variableName = "";
        this.variableValue = "";
        this.variableType = variableType;
        this.pathVariableManager = pathVariableManager;
        this.namesInUse = namesInUse;
        this.standardMessage = this.newVariable ? IDEWorkbenchMessages.PathVariableDialog_message_newVariable : IDEWorkbenchMessages.PathVariableDialog_message_existingVariable;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.newVariable) {
            shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_newVariable);
        } else {
            shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_existingVariable);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents);
        if (this.type == 2) {
            this.locationEntered = true;
            this.nameEntered = true;
            this.validateVariableValue();
        }
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(4, false));
        contents.setLayoutData((Object)new GridData(1808));
        if (this.newVariable) {
            this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_newVariable);
        } else {
            this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_existingVariable);
        }
        this.setMessage(this.standardMessage);
        return contents;
    }

    private void createWidgets(Composite contents) {
        String nameLabelText = IDEWorkbenchMessages.PathVariableDialog_variableName;
        String valueLabelText = IDEWorkbenchMessages.PathVariableDialog_variableValue;
        this.variableNameLabel = new Label(contents, 16384);
        this.variableNameLabel.setText(nameLabelText);
        this.variableNameField = new Text(contents, 2052);
        this.variableNameField.setText(this.variableName);
        this.variableNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.variableNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PathVariableDialog.this.variableNameModified();
            }
        });
        this.variableValueLabel = new Label(contents, 16384);
        this.variableValueLabel.setText(valueLabelText);
        this.variableValueField = new Text(contents, 2052);
        this.variableValueField.setText(this.variableValue);
        this.variableValueField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableValueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PathVariableDialog.this.variableValueModified();
            }
        });
        Composite buttonsComposite = new Composite(contents, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        this.fileButton = new Button(buttonsComposite, 8);
        this.fileButton.setText(IDEWorkbenchMessages.PathVariableDialog_file);
        this.fileButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if ((this.variableType & 1) == 0) {
            this.fileButton.setEnabled(false);
        }
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariableDialog.this.selectFile();
            }
        });
        this.folderButton = new Button(buttonsComposite, 8);
        this.folderButton.setText(IDEWorkbenchMessages.PathVariableDialog_folder);
        this.folderButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if ((this.variableType & 2) == 0) {
            this.folderButton.setEnabled(false);
        }
        this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariableDialog.this.selectFolder();
            }
        });
    }

    private void variableNameModified() {
        this.variableName = this.variableNameField.getText();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableName() && this.validateVariableValue());
        this.nameEntered = true;
    }

    private void variableValueModified() {
        this.variableValue = this.variableValueField.getText().trim();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableValue() && this.validateVariableName());
        this.locationEntered = true;
    }

    private void selectFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFolderTitle);
        dialog.setMessage(IDEWorkbenchMessages.PathVariableDialog_selectFolderMessage);
        dialog.setFilterPath(this.variableValue);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    private void selectFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFileTitle);
        dialog.setFilterPath(this.variableValue);
        String res = dialog.open();
        if (res != null) {
            this.variableValue = new Path(res).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.type == 2);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateVariableName() {
        boolean allowFinish = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableName.length() == 0) {
            if (this.nameEntered) {
                newValidationStatus = 3;
                message = IDEWorkbenchMessages.PathVariableDialog_variableNameEmptyMessage;
            }
        } else {
            IStatus status = this.pathVariableManager.validateName(this.variableName);
            if (!status.isOK()) {
                newValidationStatus = 3;
                message = status.getMessage();
            } else if (this.namesInUse.contains(this.variableName) && !this.variableName.equals(this.originalName)) {
                message = IDEWorkbenchMessages.PathVariableDialog_variableAlreadyExistsMessage;
                newValidationStatus = 3;
            } else {
                allowFinish = true;
            }
        }
        if (this.validationStatus == 0 || newValidationStatus == 3) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        if (!allowFinish) {
            this.setMessage(this.validationMessage, this.validationStatus);
        }
        return allowFinish;
    }

    private boolean validateVariableValue() {
        boolean allowFinish = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String message = this.standardMessage;
        int newValidationStatus = 0;
        if (this.variableValue.length() == 0) {
            if (this.locationEntered) {
                newValidationStatus = 3;
                message = IDEWorkbenchMessages.PathVariableDialog_variableValueEmptyMessage;
            }
        } else if (!Path.EMPTY.isValidPath(this.variableValue)) {
            message = IDEWorkbenchMessages.PathVariableDialog_variableValueInvalidMessage;
            newValidationStatus = 3;
        } else if (!new Path(this.variableValue).isAbsolute()) {
            message = IDEWorkbenchMessages.PathVariableDialog_pathIsRelativeMessage;
            newValidationStatus = 3;
        } else if (!IDEResourceInfoUtils.exists(this.variableValue)) {
            message = IDEWorkbenchMessages.PathVariableDialog_pathDoesNotExistMessage;
            newValidationStatus = 2;
            allowFinish = true;
        } else {
            allowFinish = true;
        }
        if (this.validationStatus == 0 || newValidationStatus > this.validationStatus) {
            this.validationStatus = newValidationStatus;
            this.validationMessage = message;
        }
        this.setMessage(this.validationMessage, this.validationStatus);
        return allowFinish;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String variableName) {
        this.originalName = this.variableName = variableName.trim();
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }

    protected boolean isResizable() {
        return true;
    }
}

