/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

public class NewFolderAction
extends ResourceAction {
    public NewFolderAction(LibraryExplorerTreeViewPage page) {
        super(Messages.getString((String)"NewFolderAction.Text"), page);
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"New folder"));
    }

    public boolean isEnabled() {
        try {
            return this.canInsertIntoSelectedContainer();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void run() {
        File container = null;
        try {
            container = this.getSelectedContainer();
        }
        catch (IOException e) {
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        if (container == null) {
            return;
        }
        String newName = this.queryNewResourceName(container);
        if (newName == null || newName.length() <= 0) {
            return;
        }
        File newFolder = new File(container, newName);
        if (newFolder.mkdir()) {
            this.fireResourceChanged(newFolder.getAbsolutePath());
        }
    }

    private String queryNewResourceName(final File container) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (string == null || string.length() <= 0) {
                    return Messages.getString((String)"NewFolderAction.emptyName");
                }
                File newPath = new File(container, string);
                if (newPath.exists()) {
                    return Messages.getString((String)"NewFolderAction.nameExists");
                }
                IStatus status = workspace.validateName(newPath.getName(), 2);
                if (!status.isOK()) {
                    return status.getMessage();
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString((String)"NewFolderAction.inputDialogTitle"), Messages.getString((String)"NewFolderAction.inputDialogMessage"), "", validator);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return null;
    }
}

