/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.dialog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.dialog.WizardResourceSettingPage;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PublishResourceWizard
extends Wizard {
    LibraryHandle handle;
    private static String windowTitle = Messages.getString((String)"PublishResourceDialog.ShellText");
    private static String PAGE_TITLE = Messages.getString((String)"PublishResourceDialog.TitleArea");
    private static String PAGE_DESC = Messages.getString((String)"PublishResourceDialog.Message");
    private static String addLibraryTitle = Messages.getString((String)"PublishResourceDialog.AddResource");
    private String filePath;
    private String fileName;
    private String folderName;
    private WizardResourceSettingPage page;
    public static int HAVE_HANDLE = 1;
    public static int HAVE_NO_HANDLE = 0;
    int type;
    private IRunnableWithProgress copyFileRunnable = null;

    public PublishResourceWizard(LibraryHandle handle, String fileName, String folderName) {
        this.setWindowTitle(windowTitle);
        this.fileName = fileName;
        this.folderName = folderName;
        this.handle = handle;
        this.filePath = handle.getFileName();
        this.type = HAVE_HANDLE;
    }

    public PublishResourceWizard(String folderName) {
        this.setWindowTitle(addLibraryTitle);
        this.fileName = null;
        this.folderName = folderName;
        this.handle = null;
        this.type = HAVE_NO_HANDLE;
    }

    public void addPages() {
        this.page = new WizardResourceSettingPage(this.type);
        if (this.type == HAVE_HANDLE) {
            this.page.setTitle(PAGE_TITLE);
            this.page.setMessage(PAGE_DESC);
            this.page.setFileName(this.fileName);
            this.page.setfolderName(this.folderName);
        } else if (this.type == HAVE_NO_HANDLE) {
            this.page.setTitle(Messages.getString((String)"PublishResourceDialog.AddText"));
            this.page.setMessage(Messages.getString((String)"PublishResourceDialog.AddMessage"));
            this.page.setfolderName(this.folderName);
        }
        this.page.setType(this.type);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.fileName = this.page.getFileName();
        this.folderName = this.page.getFolder();
        this.filePath = this.getSourceFile().getAbsolutePath();
        return this.publishiLibrary();
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    private boolean publishiLibrary() {
        if (!new File(this.filePath).exists()) {
            ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"PublishResourceAction.wizard.errorTitle"), (String)Messages.getString((String)"PublishResourceAction.wizard.message.SourceFileNotExist"));
            return false;
        }
        File targetFile = this.getTargetFile();
        if (targetFile == null) {
            ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"PublishResourceAction.wizard.errorTitle"), (String)Messages.getString((String)"PublishResourceAction.wizard.notvalidfolder"));
            return false;
        }
        if (new File(this.filePath).compareTo(targetFile) == 0) {
            ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"PublishResourceAction.wizard.errorTitle"), (String)Messages.getString((String)"PublishResourceAction.wizard.message"));
            return false;
        }
        int overwrite = 0;
        try {
            if (targetFile.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                MessageDialog d = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                overwrite = d.open();
            }
            if (overwrite == 0 && (targetFile.exists() || !targetFile.exists() && targetFile.createNewFile())) {
                this.doCopy(this.filePath, targetFile);
                IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                if (synchronizer != null) {
                    synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new ReportResourceChangeEvent((Object)this, (Object)Path.fromOSString((String)targetFile.getAbsolutePath()), 1));
                }
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return overwrite != 2;
    }

    private void doCopy(String filePath, File targetFile) throws IOException {
        if (this.copyFileRunnable == null) {
            this.copyFile(filePath, targetFile);
            return;
        }
        try {
            new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, this.copyFileRunnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void copyFile(String in, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public File getSourceFile() {
        if (this.type == HAVE_NO_HANDLE) {
            return new File(this.page.getSourceFileName());
        }
        return new File(this.filePath);
    }

    public File getTargetFile() {
        File targetFolder = new File(this.folderName);
        if (targetFolder.exists() && !targetFolder.isDirectory()) {
            return null;
        }
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        return new File(targetFolder, this.fileName);
    }

    public void setCopyFileRunnable(IRunnableWithProgress runnable) {
        this.copyFileRunnable = runnable;
    }
}

