/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.resource;

import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.swt.graphics.Image;

public class ReportElementEntry
extends ReportResourceEntry {
    private final Object element;
    private final ResourceEntry parent;
    private final INodeProvider provider;

    public ReportElementEntry(Object element, ResourceEntry parent) {
        this.element = element;
        this.parent = parent;
        this.provider = ProviderFactory.createProvider((Object)element);
    }

    public String getDisplayName() {
        return this.provider.getNodeDisplayName(this.element);
    }

    public Image getImage() {
        return this.provider.getNodeIcon(this.element);
    }

    public String getName() {
        return this.provider.getNodeDisplayName(this.element);
    }

    public ResourceEntry getParent() {
        return this.parent;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReportElementEntry)) {
            return false;
        }
        ReportElementEntry entry = (ReportElementEntry)object;
        Object entryElement = entry.getReportElement();
        if (entry == this || entryElement == this.element) {
            return true;
        }
        if (this.element != null) {
            if (this.element.equals(entryElement)) {
                return true;
            }
            if (this.parent != null && this.parent.equals(entry.getParent()) && this.element.getClass().equals(entryElement.getClass())) {
                return true;
            }
        }
        return false;
    }

    public Object getReportElement() {
        return this.element;
    }
}

