/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleTaskMenuContributor;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class ScheduleDatePicker
extends Composite {
    private Text scheduledDateText = null;
    private Button pickButton = null;
    private final List<SelectionListener> pickerListeners = new LinkedList<SelectionListener>();
    private final SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2);
    private final String initialText = "Choose Date";
    private final List<IRepositoryElement> tasks;
    private final ScheduleTaskMenuContributor contributor;
    private DateRange scheduledDate;
    private final boolean isFloating = false;

    public ScheduleDatePicker(Composite parent, AbstractTask task, int style) {
        super(parent, style);
        if (task != null && task.getScheduledForDate() != null) {
            this.scheduledDate = task.getScheduledForDate();
        }
        this.initialize((style & 0x800000) > 0 ? 0x800000 : 0);
        this.contributor = new ScheduleTaskMenuContributor(){

            protected DateRange getScheduledForDate(AbstractTask singleTaskSelection) {
                return ScheduleDatePicker.this.scheduledDate;
            }

            protected void setScheduledDate(DateRange dateRange) {
                if (dateRange != null) {
                    ScheduleDatePicker.this.scheduledDate = dateRange;
                } else {
                    ScheduleDatePicker.this.scheduledDate = null;
                }
                ScheduleDatePicker.this.updateDateText();
                ScheduleDatePicker.this.notifyPickerListeners();
            }
        };
        this.tasks = new ArrayList<IRepositoryElement>();
        this.tasks.add((IRepositoryElement)task);
    }

    public void setDatePattern(String pattern) {
        this.simpleDateFormat.applyPattern(pattern);
    }

    private void initialize(int style) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.scheduledDateText = new Text((Composite)this, style);
        this.scheduledDateText.setEditable(false);
        GridData dateTextGridData = new GridData(4, 4, false, false);
        dateTextGridData.grabExcessHorizontalSpace = true;
        dateTextGridData.widthHint = 4;
        dateTextGridData.verticalIndent = 0;
        this.scheduledDateText.setLayoutData((Object)dateTextGridData);
        this.scheduledDateText.setText("Choose Date");
        this.pickButton = new Button((Composite)this, style | 4 | 0x400);
        GridData pickButtonGridData = new GridData(131072, 4, false, true);
        pickButtonGridData.verticalIndent = 0;
        this.pickButton.setLayoutData((Object)pickButtonGridData);
        this.pickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MenuManager menuManager = ScheduleDatePicker.this.contributor.getSubMenuManager(ScheduleDatePicker.this.tasks);
                Menu menu = menuManager.createContextMenu((Control)ScheduleDatePicker.this.pickButton);
                ScheduleDatePicker.this.pickButton.setMenu(menu);
                menu.setVisible(true);
            }
        });
        this.updateDateText();
        this.pack();
    }

    public void addPickerSelectionListener(SelectionListener listener) {
        this.pickerListeners.add(listener);
    }

    public void setBackground(Color backgroundColor) {
        this.scheduledDateText.setBackground(backgroundColor);
        super.setBackground(backgroundColor);
    }

    private void notifyPickerListeners() {
        for (SelectionListener listener : this.pickerListeners) {
            listener.widgetSelected(null);
        }
    }

    private void updateDateText() {
        if (this.scheduledDate != null) {
            this.scheduledDateText.setText(this.scheduledDate.toString());
        } else {
            this.scheduledDateText.setEnabled(false);
            this.scheduledDateText.setText("Choose Date");
            this.scheduledDateText.setEnabled(true);
        }
    }

    public void setEnabled(boolean enabled) {
        this.scheduledDateText.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public DateRange getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(DateRange date) {
        this.scheduledDate = date;
        this.updateDateText();
    }

    public boolean isFloatingDate() {
        return false;
    }
}

