/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskLabelDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor overlay;
        ImageDescriptor priorityOverlay = this.getPriorityImageDescriptor(element);
        if (priorityOverlay != null) {
            decoration.addOverlay(priorityOverlay, 2);
        }
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            String repositoryUrl = query.getRepositoryUrl();
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), repositoryUrl);
            if (repositoryUrl != null && taskRepository != null) {
                if (taskRepository.getRepositoryUrl().equals(taskRepository.getRepositoryLabel())) {
                    try {
                        URL url = new URL(repositoryUrl);
                        decoration.addSuffix("   [" + url.getHost() + "]");
                    }
                    catch (MalformedURLException malformedURLException) {
                        decoration.addSuffix("   [ <unknown host> ]");
                    }
                } else {
                    decoration.addSuffix("   [" + taskRepository.getRepositoryLabel() + "]");
                }
            }
        } else if (element instanceof ITask) {
            ITask task = (ITask)element;
            if (!task.isCompleted() && (TasksUiPlugin.getTaskActivityManager().isDueToday(task) || TasksUiPlugin.getTaskActivityManager().isOverdue(task))) {
                decoration.addOverlay(CommonImages.OVERLAY_DATE_OVERDUE, 1);
            } else if (!task.isCompleted() && task.getDueDate() != null) {
                decoration.addOverlay(CommonImages.OVERLAY_DATE_DUE, 1);
            }
        } else if (element instanceof TaskRepository && (overlay = TasksUiPlugin.getDefault().getOverlayIcon(((TaskRepository)element).getConnectorKind())) != null) {
            decoration.addOverlay(overlay, 3);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private ImageDescriptor getPriorityImageDescriptor(Object element) {
        if (element instanceof ITask) {
            ITask repositoryTask = (ITask)element;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(((ITask)element).getConnectorKind());
            if (connectorUi != null) {
                return connectorUi.getTaskPriorityOverlay(repositoryTask);
            }
        }
        if (element instanceof ITask) {
            return TasksUiInternal.getPriorityImage((ITask)element);
        }
        return null;
    }
}

