/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.WorkbenchImages;

public class CompareAttachmentsAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private ISelection currentSelection;
    private static final String[] IMAGE_EXTENSIONS = new String[]{".jpg", ".gif", ".png", ".tiff", ".tif", ".bmp"};

    public CompareAttachmentsAction() {
        super("Compare Attachments");
    }

    protected CompareAttachmentsAction(String text) {
        super(text);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.currentSelection;
            Object[] elements = selection.toArray();
            final RepositoryAttachment attachment1 = (RepositoryAttachment)elements[0];
            final RepositoryAttachment attachment2 = (RepositoryAttachment)elements[1];
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setLeftLabel(attachment1.getFilename());
            cc.setLeftImage(this.getImage(attachment1));
            cc.setRightEditable(false);
            cc.setRightLabel(attachment2.getFilename());
            cc.setRightImage(this.getImage(attachment2));
            CompareEditorInput editorInput = new CompareEditorInput(cc){

                public String getTitle() {
                    return "Compare (" + attachment1.getFilename() + " - " + attachment2.getFilename() + ")";
                }

                protected Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
                    byte[] data1 = this.downloadAttachment(attachment1, pm);
                    byte[] data2 = this.downloadAttachment(attachment2, pm);
                    CompareItem left = new CompareItem(attachment1.getFilename(), data1);
                    CompareItem right = new CompareItem(attachment2.getFilename(), data2);
                    return new DiffNode((ITypedElement)left, (ITypedElement)right);
                }

                private byte[] downloadAttachment(RepositoryAttachment attachment, IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(attachment.getRepositoryKind(), attachment.getRepositoryUrl());
                        AbstractLegacyRepositoryConnector connector = (AbstractLegacyRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(attachment.getRepositoryKind());
                        AbstractAttachmentHandler handler = connector.getAttachmentHandler();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        handler.downloadAttachment(repository, attachment, (OutputStream)os, pm);
                        return os.toByteArray();
                    }
                    catch (CoreException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            CompareUI.openCompareEditor((CompareEditorInput)editorInput);
        }
    }

    private Image getImage(RepositoryAttachment attachment) {
        if (AttachmentUtil.isContext(attachment)) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_TRANSFER);
        }
        if (attachment.isPatch()) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_ATTACHMENT_PATCH);
        }
        String filename = attachment.getFilename();
        if (filename != null) {
            filename = filename.toLowerCase();
            String[] stringArray = IMAGE_EXTENSIONS;
            int n = IMAGE_EXTENSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (filename.endsWith(extension)) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                }
                ++n2;
            }
        }
        return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    class CompareItem
    implements IStreamContentAccessor,
    ITypedElement {
        private final String filename;
        private final byte[] data;

        public CompareItem(String filename, byte[] data) {
            this.filename = filename;
            this.data = data;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.data);
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return this.filename;
        }

        public String getType() {
            int n = this.filename.lastIndexOf(46);
            if (n > -1) {
                return this.filename.substring(n + 1);
            }
            return "txt";
        }
    }
}

