/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    private static final String LABEL = "Copy Details";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private final Clipboard clipboard;

    public CopyTaskDetailsAction() {
        super(LABEL);
        this.setToolTipText(LABEL);
        this.setId(ID);
        this.setImageDescriptor(CommonImages.COPY);
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.clipboard = new Clipboard(display);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        StringBuilder sb = new StringBuilder();
        Object[] seletedElements = selection.toArray();
        int i = 0;
        while (i < seletedElements.length) {
            if (i > 0) {
                sb.append("\n\n");
            }
            sb.append(CopyTaskDetailsAction.getTextForTask(seletedElements[i]));
            ++i;
        }
        if (sb.length() > 0) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
        }
    }

    public static String getTextForTask(Object object) {
        String text = "";
        if (object instanceof ITask) {
            AbstractTask task = (AbstractTask)object;
            if (task.getTaskKey() != null) {
                text = String.valueOf(text) + task.getTaskKey() + ": ";
            }
            text = String.valueOf(text) + task.getSummary();
            if (TasksUiInternal.isValidUrl(task.getUrl())) {
                text = String.valueOf(text) + "\n" + task.getUrl();
            }
        } else if (object instanceof RepositoryTaskData) {
            RepositoryTaskData taskData = (RepositoryTaskData)object;
            if (taskData.getTaskKey() != null) {
                text = String.valueOf(text) + taskData.getTaskKey() + ": ";
            }
            text = String.valueOf(text) + taskData.getSummary();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskData.getConnectorKind());
            if (connector != null) {
                text = String.valueOf(text) + "\n" + connector.getTaskUrl(taskData.getRepositoryUrl(), taskData.getTaskId());
            }
        } else if (object instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)object;
            text = String.valueOf(text) + query.getSummary();
            text = String.valueOf(text) + "\n" + query.getUrl();
        } else if (object instanceof IRepositoryElement) {
            IRepositoryElement element = (IRepositoryElement)object;
            text = element.getSummary();
        } else if (object instanceof RepositoryTaskSelection) {
            RepositoryTaskSelection selection = (RepositoryTaskSelection)object;
            text = String.valueOf(text) + selection.getId() + ": " + selection.getBugSummary();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(selection.getRepositoryKind());
            text = connector != null ? String.valueOf(text) + "\n" + connector.getTaskUrl(selection.getRepositoryUrl(), selection.getId()) : String.valueOf(text) + "\n" + selection.getRepositoryUrl();
        }
        return text;
    }
}

