/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractChangeCompletionAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkTaskCompleteAction
extends AbstractChangeCompletionAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.mark.completed";
    private static final String ACTION_NAME = "Complete";
    private final List<IRepositoryElement> selectedElements;

    public MarkTaskCompleteAction(List<IRepositoryElement> selectedElements) {
        this.selectedElements = selectedElements;
        this.setText(ACTION_NAME);
        this.setToolTipText("Mark Complete");
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_COMPLETE);
        this.setEnabled(this.shouldEnable(selectedElements));
    }

    public void run() {
        ArrayList<AbstractTask> toComplete = new ArrayList<AbstractTask>();
        for (IRepositoryElement selectedObject : this.selectedElements) {
            AbstractTask task;
            if (!(selectedObject instanceof ITask) || !(task = (AbstractTask)selectedObject).isLocal()) continue;
            toComplete.add(task);
        }
        if (toComplete.isEmpty()) {
            return;
        }
        if (toComplete.size() > 1) {
            String message = this.generateMessage(toComplete, ACTION_NAME);
            boolean markConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Mark Completed", (String)message);
            if (!markConfirmed) {
                return;
            }
        }
        ITaskList taskList = TasksUiInternal.getTaskList();
        for (AbstractTask task : toComplete) {
            task.setCompletionDate(new Date());
            taskList.notifyElementChanged((IRepositoryElement)task);
        }
    }
}

