/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractChangeCompletionAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkTaskIncompleteAction
extends AbstractChangeCompletionAction {
    private static final String ACTION_NAME = "Incomplete";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.mark.incomplete";
    private final List<IRepositoryElement> selectedElements;

    public MarkTaskIncompleteAction(List<IRepositoryElement> selectedElements) {
        this.selectedElements = selectedElements;
        this.setText(ACTION_NAME);
        this.setToolTipText("Mark Incomplete");
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_INCOMPLETE);
        this.setEnabled(this.shouldEnable(selectedElements));
    }

    public void run() {
        ArrayList<AbstractTask> toComplete = new ArrayList<AbstractTask>();
        for (IRepositoryElement selectedObject : this.selectedElements) {
            AbstractTask task;
            if (!(selectedObject instanceof ITask) || !(task = (AbstractTask)selectedObject).isLocal()) continue;
            toComplete.add(task);
        }
        if (toComplete.isEmpty()) {
            return;
        }
        if (toComplete.size() > 1) {
            String message = this.generateMessage(toComplete, ACTION_NAME);
            boolean markConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Mark Incompleted", (String)message);
            if (!markConfirmed) {
                return;
            }
        }
        ITaskList taskList = TasksUiInternal.getTaskList();
        for (AbstractTask task : toComplete) {
            task.setCompletionDate(null);
            taskList.notifyElementChanged((IRepositoryElement)task);
        }
    }
}

