/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class ToggleTaskActivationAction
extends Action
implements ITaskActivationListener {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.task.activation.toggle";
    private static final String LABEL_ACTIVATE = "Activate Task";
    private static final String LABEL_DEACTIVATE = "Deactivate Task";
    private final ITask task;

    public ToggleTaskActivationAction(ITask task) {
        Assert.isNotNull((Object)task);
        this.task = task;
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.CONTEXT_ACTIVE_CENTERED);
        this.update();
        TasksUi.getTaskActivityManager().addActivationListener((ITaskActivationListener)this);
    }

    public void dispose() {
        TasksUi.getTaskActivityManager().removeActivationListener((ITaskActivationListener)this);
    }

    private void update() {
        this.setChecked(this.task.isActive());
        if (this.task.isActive()) {
            this.setText(LABEL_DEACTIVATE);
            this.setToolTipText(LABEL_DEACTIVATE);
        } else {
            this.setText(LABEL_ACTIVATE);
            this.setToolTipText(LABEL_ACTIVATE);
        }
    }

    public void run() {
        if (!this.task.isActive()) {
            TasksUi.getTaskActivityManager().activateTask(this.task);
        } else {
            TasksUi.getTaskActivityManager().deactivateTask(this.task);
        }
        this.update();
    }

    public void taskActivated(ITask task) {
        this.update();
    }

    public void taskDeactivated(ITask task) {
        this.update();
    }

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }
}

