/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;

public abstract class AbstractReplyToCommentAction
extends Action {
    private static final String LABEL_REPLY = "Reply";
    private final AbstractTaskEditorPage editor;
    private final ITaskComment taskComment;

    public AbstractReplyToCommentAction(AbstractTaskEditorPage editor, ITaskComment taskComment) {
        this.editor = editor;
        this.taskComment = taskComment;
        this.setImageDescriptor(TasksUiImages.COMMENT_REPLY);
        this.setToolTipText(LABEL_REPLY);
    }

    protected abstract String getReplyText();

    public void run() {
        AbstractReplyToCommentAction.reply(this.editor, this.taskComment, this.getReplyText());
    }

    public static void reply(AbstractTaskEditorPage editor, ITaskComment taskComment, String text) {
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(editor.getConnectorKind());
        String reference = connectorUi.getReplyText(editor.getTaskRepository(), editor.getTask(), taskComment, false);
        StringBuilder sb = new StringBuilder();
        sb.append(reference);
        sb.append("\n");
        if (text != null) {
            CommentQuoter quoter = new CommentQuoter();
            sb.append(quoter.quote(text));
        }
        editor.appendTextToNewComment(sb.toString());
    }
}

