/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentSizeFormatter;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.themes.IThemeManager;

public class AttachmentTableLabelProvider2
extends ColumnLabelProvider {
    private final AttachmentSizeFormatter sizeFormatter = AttachmentSizeFormatter.getInstance();
    private final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
    private static final String[] IMAGE_EXTENSIONS = new String[]{"jpg", "gif", "png", "tiff", "tif", "bmp"};
    private final AttributeEditorToolkit attributeToolkit;

    public AttachmentTableLabelProvider2(AttributeEditorToolkit attributeToolkit) {
        this.attributeToolkit = attributeToolkit;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        if (columnIndex == 0) {
            int dotIndex;
            if (AttachmentUtil.isContext(attachment)) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_TRANSFER);
            }
            if (attachment.isPatch()) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_ATTACHMENT_PATCH);
            }
            String filename = attachment.getFileName();
            if (filename != null && (dotIndex = filename.lastIndexOf(46)) != -1) {
                String fileType = filename.substring(dotIndex + 1);
                String[] stringArray = IMAGE_EXTENSIONS;
                int n = IMAGE_EXTENSIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String element2 = stringArray[n2];
                    if (element2.equalsIgnoreCase(fileType)) {
                        return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                    }
                    ++n2;
                }
            }
            return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        switch (columnIndex) {
            case 0: {
                if (AttachmentUtil.isContext(attachment)) {
                    return " Task Context";
                }
                if (attachment.isPatch()) {
                    return " Patch";
                }
                return " " + attachment.getFileName();
            }
            case 1: {
                return attachment.getDescription();
            }
            case 2: {
                Long length = attachment.getLength();
                if (length < 0L) {
                    return "-";
                }
                return this.sizeFormatter.format(length);
            }
            case 3: {
                return attachment.getAuthor() != null ? attachment.getAuthor().toString() : "";
            }
            case 4: {
                return attachment.getCreationDate() != null ? EditorUtil.formatDateTime(attachment.getCreationDate()) : "";
            }
        }
        return "unrecognized column";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element, int columnIndex) {
        ITaskAttachment att = (ITaskAttachment)element;
        if (att.isDeprecated()) {
            return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
        }
        return super.getForeground(element);
    }

    public Color getBackground(Object element, int columnIndex) {
        return super.getBackground(element);
    }

    public Font getFont(Object element, int columnIndex) {
        return super.getFont(element);
    }

    public String getToolTipText(Object element) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        StringBuilder sb = new StringBuilder();
        sb.append("File: ");
        sb.append(attachment.getFileName());
        if (attachment.getContentType() != null) {
            sb.append("\n");
            sb.append("Type: ");
            sb.append(attachment.getContentType());
        }
        return sb.toString();
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 200;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getColumnText(element, cell.getColumnIndex()));
        Image image = this.getColumnImage(element, cell.getColumnIndex());
        cell.setImage(image);
        cell.setBackground(this.getBackground(element));
        cell.setForeground(this.getForeground(element));
        cell.setFont(this.getFont(element));
    }
}

