/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.data.TextTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TaskAttachmentDropListener
implements DropTargetListener {
    private final AbstractTaskEditorPage page;

    public TaskAttachmentDropListener(AbstractTaskEditorPage page) {
        this.page = page;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (FileTransfer.getInstance().isSupportedType(dataType)) {
                event.currentDataType = dataType;
                if (event.detail == 1) break;
                event.detail = 0;
                break;
            }
            ++n2;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = event.detail == 16 || (event.operations & 1) != 0 ? 1 : 0;
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] files;
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            EditorUtil.openNewAttachmentWizard(this.page, null, (AbstractTaskAttachmentSource)new TextTaskAttachmentSource(text));
        }
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0) {
            File file = new File(files[0]);
            NewAttachmentWizardDialog dialog = EditorUtil.openNewAttachmentWizard(this.page, null, (AbstractTaskAttachmentSource)new FileTaskAttachmentSource(file));
            if (files.length > 1) {
                dialog.setMessage("Note that only the first file dragged will be attached.", 2);
            }
        }
    }
}

