/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachScreenshotAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskFromSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowInTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.NewTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.RepositoryTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.TaskFormPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskPlanningEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;

public class TaskEditorActionContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private TaskEditor editor;
    private final OpenWithBrowserAction openWithBrowserAction = new OpenWithBrowserAction();
    private final CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private final AbstractTaskEditorAction attachAction = new AttachAction();
    private final AbstractTaskEditorAction attachScreenshotAction = new AttachScreenshotAction();
    private final SynchronizeEditorAction synchronizeEditorAction = new SynchronizeEditorAction();
    private final ShowInTaskListAction showInTaskListAction = new ShowInTaskListAction();
    private final NewTaskFromSelectionAction newTaskFromSelectionAction = new NewTaskFromSelectionAction();
    private final GlobalAction cutAction = new GlobalAction(ActionFactory.CUT.getId());
    private final GlobalAction undoAction;
    private final GlobalAction redoAction;
    private final GlobalAction copyAction;
    private final GlobalAction pasteAction;
    private final GlobalAction selectAllAction;

    public TaskEditorActionContributor() {
        this.cutAction.setText(WorkbenchMessages.Workbench_cut);
        this.cutAction.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
        this.cutAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT_DISABLED"));
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.pasteAction = new GlobalAction(ActionFactory.PASTE.getId());
        this.pasteAction.setText(WorkbenchMessages.Workbench_paste);
        this.pasteAction.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
        this.pasteAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new GlobalAction(ActionFactory.COPY.getId());
        this.copyAction.setText(WorkbenchMessages.Workbench_copy);
        this.copyAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.undoAction = new GlobalAction(ActionFactory.UNDO.getId());
        this.undoAction.setText(WorkbenchMessages.Workbench_undo);
        this.undoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO_DISABLED"));
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new GlobalAction(ActionFactory.REDO.getId());
        this.redoAction.setText(WorkbenchMessages.Workbench_redo);
        this.redoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO_DISABLED"));
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.selectAllAction = new GlobalAction(ActionFactory.SELECT_ALL.getId());
        this.selectAllAction.setText(WorkbenchMessages.Workbench_selectAll);
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.selectAllAction.setEnabled(true);
    }

    public void addClipboardActions(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.copyTaskDetailsAction);
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.newTaskFromSelectionAction);
        manager.add((IContributionItem)new Separator());
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        IFormPage page = this.getActivePage();
        boolean addClipboard = page instanceof TaskPlanningEditor || page instanceof AbstractRepositoryTaskEditor || page instanceof AbstractTaskEditorPage;
        this.contextMenuAboutToShow(mng, addClipboard);
    }

    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        ITask task;
        if (this.editor != null) {
            this.updateSelectableActions(this.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(manager);
        }
        if (this.editor.getTaskEditorInput() == null) {
            MenuManager subMenuManager = new MenuManager("Add to Task List");
            ArrayList categories = new ArrayList(TasksUiInternal.getTaskList().getCategories());
            Collections.sort(categories);
            for (final AbstractTaskCategory category : categories) {
                if (category instanceof UnmatchedTaskContainer) continue;
                Action action = new Action(){

                    public void run() {
                        TaskEditorActionContributor.this.moveToCategory(category);
                    }
                };
                String text = category.getSummary();
                action.setText(text);
                action.setImageDescriptor(TasksUiImages.CATEGORY);
                subMenuManager.add((IAction)action);
            }
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getSelection()));
            manager.add((IContributionItem)subMenuManager);
        } else if (!(this.editor.getEditorInput() instanceof NewTaskEditorInput) && (task = this.editor.getTaskEditorInput().getTask()) != null) {
            StructuredSelection selection = new StructuredSelection((Object)task);
            this.openWithBrowserAction.selectionChanged((IStructuredSelection)selection);
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
            this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditor()));
            this.showInTaskListAction.selectionChanged((IStructuredSelection)selection);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.synchronizeEditorAction);
            manager.add((IAction)this.openWithBrowserAction);
            if (task.isActive()) {
                manager.add((IAction)new TaskDeactivateAction(){

                    public void run() {
                        super.run(task);
                    }
                });
            } else {
                manager.add((IAction)new TaskActivateAction(){

                    public void run() {
                        super.run(task);
                    }
                });
            }
            manager.add((IAction)this.showInTaskListAction);
            manager.add((IContributionItem)new Separator());
            for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
                for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                    if (!"tasks".equals(menuPath)) continue;
                    ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
                    selectedElements.add((IRepositoryElement)task);
                    MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                    if (subMenuManager == null) continue;
                    subMenuManager.setVisible(selectedElements.size() > 0 && selectedElements.get(0) instanceof ITask);
                    manager.add((IContributionItem)subMenuManager);
                }
            }
            manager.add((IContributionItem)new GroupMarker("navigate"));
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker("operations"));
            manager.add((IContributionItem)new GroupMarker("context"));
            manager.add((IContributionItem)new Separator());
            if (this.getActivePage() instanceof AbstractRepositoryTaskEditor) {
                this.attachAction.selectionChanged((IStructuredSelection)selection);
                this.attachAction.setEditor(this.editor);
                this.attachScreenshotAction.selectionChanged((IStructuredSelection)selection);
                this.attachScreenshotAction.setEditor(this.editor);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.attachAction);
                manager.add((IAction)this.attachScreenshotAction);
            }
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void moveToCategory(AbstractTaskCategory category) {
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput repositoryTaskEditorInput = (RepositoryTaskEditorInput)input;
            final IProgressService svc = PlatformUI.getWorkbench().getProgressService();
            final AddExistingTaskJob job = new AddExistingTaskJob(repositoryTaskEditorInput.getRepository(), repositoryTaskEditorInput.getId(), category);
            job.schedule();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    svc.showInDialog(TaskEditorActionContributor.this.getEditor().getSite().getShell(), (Job)job);
                }
            });
        }
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            this.undoAction.selectionChanged(selection);
            this.redoAction.selectionChanged(selection);
            this.selectAllAction.selectionChanged(selection);
            this.newTaskFromSelectionAction.selectionChanged(selection);
        }
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.registerGlobalHandlers(bars);
    }

    public TaskEditor getEditor() {
        return this.editor;
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (activeEditor instanceof TaskEditor) {
            this.editor = (TaskEditor)activeEditor;
            this.updateSelectableActions(this.getSelection());
        } else {
            this.editor = null;
        }
    }

    public void setActivePage(IEditorPart activePage) {
        this.updateSelectableActions(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelectableActions(event.getSelection());
    }

    private void registerGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.updateActionBars();
    }

    private void unregisterGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
        bars.updateActionBars();
    }

    public void forceActionsEnabled() {
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.selectAllAction.setEnabled(true);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    private IFormPage getActivePage() {
        return this.editor != null ? this.editor.getActivePageInstance() : null;
    }

    private ISelection getSelection() {
        if (this.editor != null && this.editor.getSite().getSelectionProvider() != null) {
            return this.editor.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    private class GlobalAction
    extends Action {
        private final String actionId;

        public GlobalAction(String actionId) {
            this.actionId = actionId;
        }

        public void run() {
            IFormPage page = TaskEditorActionContributor.this.getActivePage();
            if (page instanceof TaskFormPage) {
                TaskFormPage editor = (TaskFormPage)page;
                editor.doAction(this.actionId);
            } else if (page instanceof AbstractTaskEditorPage) {
                AbstractTaskEditorPage editor = (AbstractTaskEditorPage)page;
                editor.doAction(this.actionId);
            } else {
                EditorUtil.doAction(this.actionId, EditorUtil.getFocusControl(TaskEditorActionContributor.this.getActivePage()));
            }
            TaskEditorActionContributor.this.updateSelectableActions(TaskEditorActionContributor.this.getSelection());
        }

        public void selectionChanged(ISelection selection) {
            IFormPage page = TaskEditorActionContributor.this.getActivePage();
            if (page instanceof TaskFormPage) {
                TaskFormPage editor = (TaskFormPage)page;
                this.setEnabled(editor.canPerformAction(this.actionId));
            } else if (page instanceof AbstractTaskEditorPage) {
                AbstractTaskEditorPage editor = (AbstractTaskEditorPage)page;
                this.setEnabled(editor.canPerformAction(this.actionId));
            } else {
                this.setEnabled(EditorUtil.canPerformAction(this.actionId, EditorUtil.getFocusControl(TaskEditorActionContributor.this.getActivePage())));
            }
        }
    }
}

