/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorActionPart
extends AbstractTaskEditorPart {
    private static final String KEY_OPERATION = "operation";
    private static final int DEFAULT_FIELD_WIDTH = 150;
    private static final String LABEL_BUTTON_SUBMIT = "Submit";
    private static final int RADIO_OPTION_WIDTH = 120;
    private List<Button> operationButtons;
    private Button submitButton;
    private Button attachContextButton;
    private Button addToCategory;
    private CCombo categoryChooser;
    private AbstractTaskCategory category;
    private TaskAttribute selectedOperationAttribute;

    public TaskEditorActionPart() {
        this.setPartName("Actions");
    }

    protected void addAttachContextButton(Composite buttonComposite, FormToolkit toolkit) {
        this.attachContextButton = toolkit.createButton(buttonComposite, "Attach Context", 32);
        this.attachContextButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
    }

    private void createActionButtons(Composite buttonComposite, FormToolkit toolkit) {
        this.submitButton = toolkit.createButton(buttonComposite, LABEL_BUTTON_SUBMIT, 0);
        GridData submitButtonData = new GridData(32);
        submitButtonData.widthHint = 100;
        this.submitButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SUBMIT));
        this.submitButton.setLayoutData((Object)submitButtonData);
        this.submitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TaskEditorActionPart.this.getTaskEditorPage().doSubmit();
            }
        });
        this.setSubmitEnabled(true);
        toolkit.createLabel(buttonComposite, "    ");
        this.addAttachContextButton(buttonComposite, toolkit);
    }

    private void createCategoryChooser(Composite buttonComposite, FormToolkit toolkit) {
        this.addToCategory = this.getManagedForm().getToolkit().createButton(buttonComposite, "Add to Category", 32);
        this.categoryChooser = new CCombo(buttonComposite, 0x800008);
        this.categoryChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.categoryChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        toolkit.adapt((Control)this.categoryChooser, false, false);
        this.categoryChooser.setFont(TEXT_FONT);
        ITaskList taskList = TasksUiInternal.getTaskList();
        final ArrayList categories = new ArrayList(taskList.getCategories());
        Collections.sort(categories, new Comparator<AbstractTaskContainer>(){

            @Override
            public int compare(AbstractTaskContainer c1, AbstractTaskContainer c2) {
                if (c1.equals((Object)TasksUiPlugin.getTaskList().getDefaultCategory())) {
                    return -1;
                }
                if (c2.equals((Object)TasksUiPlugin.getTaskList().getDefaultCategory())) {
                    return 1;
                }
                return c1.getSummary().compareToIgnoreCase(c2.getSummary());
            }
        });
        for (IRepositoryElement category : categories) {
            this.categoryChooser.add(category.getSummary());
        }
        this.categoryChooser.select(0);
        this.categoryChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TaskEditorActionPart.this.categoryChooser.getSelectionIndex() != -1) {
                    TaskEditorActionPart.this.category = (AbstractTaskCategory)categories.get(TaskEditorActionPart.this.categoryChooser.getSelectionIndex());
                }
            }
        });
        this.categoryChooser.setEnabled(false);
        this.addToCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskEditorActionPart.this.markDirty();
                if (!TaskEditorActionPart.this.addToCategory.getSelection()) {
                    TaskEditorActionPart.this.category = null;
                } else if (TaskEditorActionPart.this.categoryChooser.getSelectionIndex() != -1) {
                    TaskEditorActionPart.this.category = (AbstractTaskCategory)categories.get(TaskEditorActionPart.this.categoryChooser.getSelectionIndex());
                }
                TaskEditorActionPart.this.categoryChooser.setEnabled(TaskEditorActionPart.this.addToCategory.getSelection());
            }
        });
        GridDataFactory.fillDefaults().hint(150, -1).span(3, -1).applyTo((Control)this.categoryChooser);
    }

    public AbstractTaskCategory getCategory() {
        return this.category;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        Composite buttonComposite = toolkit.createComposite((Composite)section);
        GridLayout buttonLayout = new GridLayout();
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)buttonComposite);
        buttonLayout.numColumns = 4;
        buttonComposite.setLayout((Layout)buttonLayout);
        if (this.getTaskEditorPage().needsAddToCategory()) {
            this.createCategoryChooser(buttonComposite, toolkit);
        }
        this.selectedOperationAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.operation");
        if (this.selectedOperationAttribute != null && KEY_OPERATION.equals(this.selectedOperationAttribute.getMetaData().getType())) {
            TaskOperation selectedOperation = this.getTaskData().getAttributeMapper().getTaskOperation(this.selectedOperationAttribute);
            this.createRadioButtons(buttonComposite, toolkit, selectedOperation);
        }
        this.createActionButtons(buttonComposite, toolkit);
        toolkit.paintBordersFor(buttonComposite);
        section.setClient((Control)buttonComposite);
        this.setSection(toolkit, section);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, Button button) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            editor.createControl(composite, toolkit);
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            if (editor.getControl() instanceof CCombo) {
                gd.heightHint = 20;
                gd.widthHint = 120;
            } else {
                gd.widthHint = 115;
            }
            editor.getControl().setLayoutData((Object)gd);
            editor.getControl().addFocusListener((org.eclipse.swt.events.FocusListener)new FocusListener(button));
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }

    private void createRadioButtons(Composite buttonComposite, FormToolkit toolkit, TaskOperation selectedOperation) {
        List operations = this.getTaskData().getAttributeMapper().getTaskOperations(this.selectedOperationAttribute);
        if (operations.size() > 0) {
            this.operationButtons = new ArrayList<Button>();
            Button selectedButton = null;
            for (TaskOperation operation : operations) {
                Button button = toolkit.createButton(buttonComposite, operation.getLabel(), 16);
                button.setFont(TEXT_FONT);
                button.setData(KEY_OPERATION, (Object)operation);
                GridData radioData = new GridData(32);
                TaskAttribute associatedAttribute = this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(operation);
                if (associatedAttribute != null) {
                    radioData.horizontalSpan = 1;
                    this.addAttribute(buttonComposite, toolkit, associatedAttribute, button);
                } else {
                    radioData.horizontalSpan = 4;
                }
                button.setLayoutData((Object)radioData);
                button.addSelectionListener((SelectionListener)new RadioButtonListener());
                this.operationButtons.add(button);
                if (!operation.equals((Object)selectedOperation)) continue;
                selectedButton = button;
            }
            if (selectedButton == null && !this.operationButtons.isEmpty()) {
                selectedButton = this.operationButtons.get(0);
            }
            this.setSelectedRadionButton(selectedButton, false);
        }
    }

    public boolean getAttachContext() {
        if (this.attachContextButton == null || this.attachContextButton.isDisposed()) {
            return false;
        }
        return this.attachContextButton.getSelection();
    }

    public void setSubmitEnabled(boolean enabled) {
        if (this.submitButton != null && !this.submitButton.isDisposed()) {
            this.submitButton.setEnabled(enabled);
            if (enabled) {
                this.submitButton.setToolTipText("Submit to " + this.getTaskEditorPage().getTaskRepository().getRepositoryUrl());
            }
        }
    }

    private void setSelectedRadionButton(Button selectedButton, boolean updateModel) {
        selectedButton.setSelection(true);
        for (Button button : this.operationButtons) {
            if (button == selectedButton) continue;
            button.setSelection(false);
        }
        if (updateModel) {
            TaskOperation taskOperation = (TaskOperation)selectedButton.getData(KEY_OPERATION);
            this.getTaskData().getAttributeMapper().setTaskOperation(this.selectedOperationAttribute, taskOperation);
            this.getModel().attributeChanged(this.selectedOperationAttribute);
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private final Button button;

        public FocusListener(Button button) {
            this.button = button;
        }

        public void focusGained(FocusEvent event) {
            TaskEditorActionPart.this.setSelectedRadionButton(this.button, true);
        }
    }

    private class RadioButtonListener
    extends SelectionAdapter {
        private RadioButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            TaskEditorActionPart.this.setSelectedRadionButton((Button)event.widget, true);
        }
    }
}

