/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider2;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentsTableContentProvider2;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiMenus;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.WorkbenchImages;

public class TaskEditorAttachmentPart
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.tasks.ui.editor.menu.attachments";
    private final String[] attachmentsColumns = new String[]{"Name", "Description", "Size", "Creator", "Created"};
    private final int[] attachmentsColumnWidths = new int[]{130, 150, 70, 100, 100};
    private List<TaskAttribute> attachments;
    private boolean hasIncoming;
    private MenuManager menuManager;
    private Composite attachmentsComposite;

    public TaskEditorAttachmentPart() {
        this.setPartName("Attachments");
    }

    private void createAttachmentTable(FormToolkit toolkit, Composite attachmentsComposite) {
        Table attachmentsTable = toolkit.createTable(attachmentsComposite, 67588);
        attachmentsTable.setLinesVisible(true);
        attachmentsTable.setHeaderVisible(true);
        attachmentsTable.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)attachmentsTable);
        int i = 0;
        while (i < this.attachmentsColumns.length) {
            TableColumn column = new TableColumn(attachmentsTable, 16384, i);
            column.setText(this.attachmentsColumns[i]);
            column.setWidth(this.attachmentsColumnWidths[i]);
            ++i;
        }
        attachmentsTable.getColumn(2).setAlignment(131072);
        TableViewer attachmentsViewer = new TableViewer(attachmentsTable);
        attachmentsViewer.setUseHashlookup(true);
        attachmentsViewer.setColumnProperties(this.attachmentsColumns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)attachmentsViewer, (int)2);
        attachmentsViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ITaskAttachment attachment1 = (ITaskAttachment)e1;
                ITaskAttachment attachment2 = (ITaskAttachment)e2;
                Date created1 = attachment1.getCreationDate();
                Date created2 = attachment2.getCreationDate();
                if (created1 != null && created2 != null) {
                    return created1.compareTo(created2);
                }
                if (created1 == null && created2 != null) {
                    return -1;
                }
                if (created1 != null && created2 == null) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<ITaskAttachment> attachmentList = new ArrayList<ITaskAttachment>(this.attachments.size());
        for (TaskAttribute attribute : this.attachments) {
            TaskAttachment taskAttachment = new TaskAttachment(this.getModel().getTaskRepository(), this.getModel().getTask(), attribute);
            this.getTaskData().getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, attribute);
            attachmentList.add((ITaskAttachment)taskAttachment);
        }
        attachmentsViewer.setContentProvider((IContentProvider)new AttachmentsTableContentProvider2(attachmentList));
        attachmentsViewer.setLabelProvider((IBaseLabelProvider)new AttachmentTableLabelProvider2(this.getTaskEditorPage().getAttributeEditorToolkit()));
        attachmentsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    ITaskAttachment attachment = (ITaskAttachment)selection.getFirstElement();
                    TasksUiUtil.openUrl(attachment.getUrl());
                }
            }
        });
        attachmentsViewer.addSelectionChangedListener((ISelectionChangedListener)this.getTaskEditorPage());
        attachmentsViewer.setInput((Object)this.getTaskData());
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TasksUiMenus.fillTaskAttachmentMenu(manager);
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)attachmentsViewer, false);
        Menu menu = this.menuManager.createContextMenu((Control)attachmentsTable);
        attachmentsTable.setMenu(menu);
    }

    private void createButtons(Composite attachmentsComposite, FormToolkit toolkit) {
        Composite attachmentControlsComposite = toolkit.createComposite(attachmentsComposite);
        attachmentControlsComposite.setLayout((Layout)new GridLayout(2, false));
        attachmentControlsComposite.setLayoutData((Object)new GridData(1));
        Button attachFileButton = toolkit.createButton(attachmentControlsComposite, "Attach...", 8);
        attachFileButton.setImage(WorkbenchImages.getImage((String)"IMG_OBJ_FILE"));
        attachFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorUtil.openNewAttachmentWizard(TaskEditorAttachmentPart.this.getTaskEditorPage(), TaskAttachmentWizard.Mode.DEFAULT, null);
            }
        });
        this.getTaskEditorPage().registerDefaultDropListener((Control)attachFileButton);
        Button attachScreenshotButton = toolkit.createButton(attachmentControlsComposite, "Attach Screenshot...", 8);
        attachScreenshotButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_CAPTURE));
        attachScreenshotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorUtil.openNewAttachmentWizard(TaskEditorAttachmentPart.this.getTaskEditorPage(), TaskAttachmentWizard.Mode.SCREENSHOT, null);
            }
        });
        this.getTaskEditorPage().registerDefaultDropListener((Control)attachScreenshotButton);
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        final Section section = this.createSection(parent, toolkit, this.hasIncoming);
        section.setText(String.valueOf(this.getPartName()) + " (" + this.attachments.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (TaskEditorAttachmentPart.this.attachmentsComposite == null) {
                        TaskEditorAttachmentPart.this.expandSection(toolkit, section);
                        TaskEditorAttachmentPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.attachmentsComposite = toolkit.createComposite((Composite)section);
        this.attachmentsComposite.setLayout((Layout)new GridLayout(1, false));
        this.attachmentsComposite.setLayoutData((Object)new GridData(1808));
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.attachments.size() > 0) {
            this.createAttachmentTable(toolkit, this.attachmentsComposite);
        } else {
            Label label = toolkit.createLabel(this.attachmentsComposite, "No attachments");
            this.getTaskEditorPage().registerDefaultDropListener((Control)label);
        }
        this.createButtons(this.attachmentsComposite, toolkit);
        section.setClient((Control)this.attachmentsComposite);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.dispose();
    }

    private void initialize() {
        this.attachments = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "attachment");
        for (TaskAttribute attachmentAttribute : this.attachments) {
            if (!this.getModel().hasIncomingChanges(attachmentAttribute)) continue;
            this.hasIncoming = true;
            break;
        }
    }
}

