/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleDatePicker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorPlanningPart
extends AbstractTaskEditorPart {
    private static final String CLEAR = "Clear";
    private static final int DEFAULT_ESTIMATED_TIME = 1;
    private static final String NO_TIME_ELAPSED = "0 seconds";
    private static final String RESET = "Reset";
    private static final int CONTROL_WIDTH = 135;
    private DatePicker dueDatePicker;
    private Text elapsedTimeText;
    private Spinner estimatedTime;
    private ScheduleDatePicker scheduleDatePicker;
    private AbstractTask task;
    private final ITaskListChangeListener TASK_LIST_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || (updateTask = (AbstractTask)taskContainerDelta.getElement()) == null || TaskEditorPlanningPart.this.task == null || !updateTask.getHandleIdentifier().equals(TaskEditorPlanningPart.this.task.getHandleIdentifier()) || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskEditorPlanningPart.this.updateFromTask(updateTask);
                    }
                });
            }
        }
    };
    private final ITaskActivityListener timingListener = new TaskActivityAdapter(){

        public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
            if (task.equals(TaskEditorPlanningPart.this.task)) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TaskEditorPlanningPart.this.elapsedTimeText != null && !TaskEditorPlanningPart.this.elapsedTimeText.isDisposed()) {
                            TaskEditorPlanningPart.this.updateElapsedTime();
                        }
                    }
                });
            }
        }
    };

    public TaskEditorPlanningPart() {
        this.setPartName("Personal Planning");
    }

    public void commit(boolean onSave) {
        AbstractTask task = (AbstractTask)this.getTaskEditorPage().getTask();
        Assert.isNotNull((Object)task);
        if (this.scheduleDatePicker != null && this.scheduleDatePicker.getScheduledDate() != null) {
            if (task.getScheduledForDate() == null || task.getScheduledForDate() != null && !this.scheduleDatePicker.getScheduledDate().equals((Object)task.getScheduledForDate()) || task.getScheduledForDate().isDay()) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, this.scheduleDatePicker.getScheduledDate());
                task.setReminded(false);
            }
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, null);
            task.setReminded(false);
        }
        if (this.estimatedTime != null) {
            task.setEstimatedTimeHours(this.estimatedTime.getSelection());
        }
        if (this.dueDatePicker != null && this.dueDatePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)task, this.dueDatePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)task, null);
        }
        super.commit(onSave);
    }

    private void createActualTime(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, "Active:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText("Time working on this task");
        Composite nameValueComp = this.createComposite(parent, 2, toolkit);
        this.elapsedTimeText = toolkit.createText(nameValueComp, null);
        this.updateElapsedTime();
        GridData td = new GridData(768);
        td.grabExcessHorizontalSpace = true;
        this.elapsedTimeText.setLayoutData((Object)td);
        this.elapsedTimeText.setEditable(false);
        ImageHyperlink resetActivityTimeButton = toolkit.createImageHyperlink(nameValueComp, 0);
        resetActivityTimeButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        resetActivityTimeButton.setToolTipText(RESET);
        resetActivityTimeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (MessageDialog.openConfirm((Shell)TaskEditorPlanningPart.this.getControl().getShell(), (String)"Confirm Activity Time Deletion", (String)"Do you wish to reset your activity time on this task?\n\nThis will take immediate affect and can not be undone.")) {
                    MonitorUi.getActivityContextManager().removeActivityTime(TaskEditorPlanningPart.this.task.getHandleIdentifier(), 0L, System.currentTimeMillis());
                }
            }
        });
    }

    private void updateElapsedTime() {
        String elapsedTimeString = DateUtil.getFormattedDurationShort((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)this.task));
        if (elapsedTimeString.equals("")) {
            elapsedTimeString = NO_TIME_ELAPSED;
        }
        this.elapsedTimeText.setText(elapsedTimeString);
    }

    private Composite createComposite(Composite parent, int col, FormToolkit toolkit) {
        Composite nameValueComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        return nameValueComp;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.task = (AbstractTask)this.getTaskEditorPage().getTask();
        boolean hasDueDate = !this.getTaskEditorPage().getConnector().hasRepositoryDueDate(this.getTaskEditorPage().getTaskRepository(), (ITask)this.task, this.getTaskData());
        Section section = this.createSection(parent, toolkit, true);
        Composite composite = this.getManagedForm().getToolkit().createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(hasDueDate ? 4 : 6, false));
        this.createScheduledDatePicker(toolkit, composite);
        if (hasDueDate) {
            this.createDueDatePicker(toolkit, composite);
        }
        this.createEstimatedTime(toolkit, composite);
        this.createActualTime(toolkit, composite);
        TasksUiInternal.getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.timingListener);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.setSection(toolkit, section);
    }

    private void createDueDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, "Due:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.dueDatePicker = new DatePicker(composite, 0x800000, "Choose Date", true, 0);
        GridDataFactory.fillDefaults().hint(135, -1).applyTo((Control)this.dueDatePicker);
        this.dueDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.dueDatePicker.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (this.task.getDueDate() != null) {
            Calendar calendar = TaskActivityUtil.getCalendar();
            calendar.setTime(this.task.getDueDate());
            this.dueDatePicker.setDate(calendar);
        }
        this.dueDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TaskEditorPlanningPart.this.markDirty();
            }
        });
        toolkit.adapt((Control)this.dueDatePicker, false, false);
        toolkit.paintBordersFor(composite);
        ImageHyperlink clearDueDate = toolkit.createImageHyperlink(composite, 0);
        clearDueDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearDueDate.setToolTipText(CLEAR);
        clearDueDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskEditorPlanningPart.this.dueDatePicker.setDate(null);
                TaskEditorPlanningPart.this.markDirty();
            }
        });
    }

    private void createEstimatedTime(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, "Estimated:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.estimatedTime = new Spinner(composite, 0x800000);
        this.estimatedTime.setDigits(0);
        this.estimatedTime.setMaximum(100);
        this.estimatedTime.setMinimum(0);
        this.estimatedTime.setIncrement(1);
        this.estimatedTime.setSelection(this.task.getEstimatedTimeHours());
        this.estimatedTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.estimatedTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskEditorPlanningPart.this.markDirty();
            }
        });
        ImageHyperlink clearEstimated = toolkit.createImageHyperlink(composite, 0);
        clearEstimated.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearEstimated.setToolTipText(CLEAR);
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskEditorPlanningPart.this.estimatedTime.setSelection(0);
                TaskEditorPlanningPart.this.markDirty();
            }
        });
        toolkit.paintBordersFor(composite);
    }

    private void createScheduledDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, "Scheduled:");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.scheduleDatePicker = new ScheduleDatePicker(composite, this.task, 0x800000);
        GridDataFactory.fillDefaults().hint(135, -1).applyTo((Control)this.scheduleDatePicker);
        this.scheduleDatePicker.setData("FormWidgetFactory.drawBorder", "textBorder");
        toolkit.adapt((Control)this.scheduleDatePicker, false, false);
        toolkit.paintBordersFor(composite);
        this.scheduleDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduleDatePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                TaskEditorPlanningPart.this.markDirty();
            }
        });
        ImageHyperlink clearScheduledDate = toolkit.createImageHyperlink(composite, 0);
        clearScheduledDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearScheduledDate.setToolTipText(CLEAR);
        clearScheduledDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskEditorPlanningPart.this.scheduleDatePicker.setScheduledDate(null);
                TaskEditorPlanningPart.this.task.setReminded(false);
                TaskEditorPlanningPart.this.markDirty();
            }
        });
    }

    public void dispose() {
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.timingListener);
        TasksUiInternal.getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
    }

    private void updateFromTask(AbstractTask updateTask) {
        if (this.scheduleDatePicker != null && !this.scheduleDatePicker.isDisposed()) {
            if (updateTask.getScheduledForDate() != null) {
                this.scheduleDatePicker.setScheduledDate(updateTask.getScheduledForDate());
            } else {
                this.scheduleDatePicker.setScheduledDate(null);
            }
        }
        if (this.estimatedTime != null && !this.estimatedTime.isDisposed()) {
            this.estimatedTime.setSelection(updateTask.getEstimatedTimeHours());
        }
    }
}

