/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.PreviewAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.WorkbenchPage;

public class TaskEditorRichTextPart
extends AbstractTaskEditorPart {
    private RichTextAttributeEditor editor;
    private TaskAttribute attribute;
    private Composite composite;
    private int sectionStyle;

    public TaskEditorRichTextPart() {
        this.setSectionStyle(322);
    }

    public void appendText(String text) {
        if (this.editor == null) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder();
        String oldText = this.editor.getViewer().getDocument().get();
        if (strBuilder.length() != 0) {
            strBuilder.append("\n");
        }
        strBuilder.append(oldText);
        strBuilder.append(text);
        this.editor.getViewer().getDocument().set(strBuilder.toString());
        TaskAttribute attribute = this.getTaskData().getRoot().getMappedAttribute("task.common.comment.new");
        if (attribute != null) {
            attribute.setValue(strBuilder.toString());
            this.getTaskEditorPage().getModel().attributeChanged(attribute);
        }
        this.editor.getViewer().getTextWidget().setCaretOffset(strBuilder.length());
    }

    public int getSectionStyle() {
        return this.sectionStyle;
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.attribute == null) {
            return;
        }
        AbstractAttributeEditor attributEditor = this.createAttributeEditor(this.attribute);
        if (!(attributEditor instanceof RichTextAttributeEditor)) {
            String clazz = attributEditor != null ? attributEditor.getClass().getName() : "<null>";
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Expected an instance of RichTextAttributeEditor, got \"" + clazz + "\""));
            return;
        }
        Section section = this.createSection(parent, toolkit, this.sectionStyle);
        this.composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        this.editor = (RichTextAttributeEditor)attributEditor;
        AbstractRenderingEngine renderingEngine = this.getTaskEditorPage().getAttributeEditorToolkit().getRenderingEngine(this.attribute);
        if (renderingEngine != null) {
            PreviewAttributeEditor previewEditor = new PreviewAttributeEditor(this.getModel(), this.attribute, this.getTaskEditorPage().getTaskRepository(), renderingEngine, this.editor);
            previewEditor.createControl(this.composite, toolkit);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(previewEditor.getControl());
        } else {
            this.editor.createControl(this.composite, toolkit);
            if (this.editor.isReadOnly()) {
                GridDataFactory.fillDefaults().minSize(500, 0).hint(500, -1).applyTo(this.editor.getControl());
            } else {
                GridData gd = new GridData();
                int width = this.getEditorWidth();
                Point size = this.editor.getViewer().getTextWidget().computeSize(width, -1, true);
                gd.widthHint = 500;
                gd.minimumWidth = 500;
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.heightHint = Math.min(Math.max(140, size.y), 420);
                if (this.getExpandVertically()) {
                    gd.verticalAlignment = 4;
                    gd.grabExcessVerticalSpace = true;
                }
                this.editor.getControl().setLayoutData((Object)gd);
                this.editor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            }
        }
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.editor);
        toolkit.paintBordersFor(this.composite);
        section.setClient((Control)this.composite);
        this.setSection(toolkit, section);
    }

    private int getEditorWidth() {
        EditorAreaHelper editorManager;
        int widthHint = 0;
        if (this.getManagedForm() != null && this.getManagedForm().getForm() != null) {
            widthHint = this.getManagedForm().getForm().getClientArea().width - 90;
        }
        if (widthHint <= 0 && this.getTaskEditorPage().getEditor().getEditorSite() != null && this.getTaskEditorPage().getEditor().getEditorSite().getPage() != null && (editorManager = ((WorkbenchPage)this.getTaskEditorPage().getEditor().getEditorSite().getPage()).getEditorPresentation()) != null && editorManager.getLayoutPart() != null) {
            widthHint = editorManager.getLayoutPart().getControl().getBounds().width - 90;
        }
        if (widthHint <= 0) {
            widthHint = 500;
        }
        return widthHint;
    }

    public TaskAttribute getAttribute() {
        return this.attribute;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected RichTextAttributeEditor getEditor() {
        return this.editor;
    }

    public void setAttribute(TaskAttribute attribute) {
        this.attribute = attribute;
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.getControl().setFocus();
        }
    }
}

