/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;

public class TaskRelationHyperlinkDetector
extends TaskHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        TaskRepository taskRepository = this.getTaskRepository(textViewer);
        if (taskRepository != null) {
            String prefix = this.extractPrefix(textViewer, region.getOffset());
            String postfix = this.extractPostfix(textViewer, region.getOffset());
            String taskKey = String.valueOf(prefix) + postfix;
            if (taskKey != null) {
                Region hyperlinkRegion = new Region(region.getOffset() - prefix.length(), taskKey.length());
                return new IHyperlink[]{new TaskHyperlink((IRegion)hyperlinkRegion, taskRepository, taskKey)};
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        if (i > document.getLength()) {
            return "";
        }
        try {
            if (this.isSeparator(document.getChar(i))) {
                return "";
            }
            while (true) {
                if (i <= 0) {
                    return document.get(i, offset - i);
                }
                char ch = document.getChar(i - 1);
                if (this.isSeparator(ch)) {
                    return document.get(i, offset - i);
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractPostfix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        int length = document.getLength();
        if (i > length) {
            return "";
        }
        try {
            if (this.isSeparator(document.getChar(i))) {
                return "";
            }
            while (true) {
                if (i >= length - 1) {
                    return document.get(offset, i - offset + 1);
                }
                char ch = document.getChar(i + 1);
                if (this.isSeparator(ch)) {
                    return document.get(offset, i - offset + 1);
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean isSeparator(char ch) {
        return Character.isWhitespace(ch) || ch == ',';
    }
}

