/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskAttributeDiff;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataDiff {
    private static final int MAX_CHANGED_ATTRIBUTES = 2;
    private final String[] ATTRIBUTES_IDS = new String[]{"task.common.summary", "task.common.description", "task.common.product", "task.common.priority", "task.common.user.assigned", "task.common.status"};
    private final TaskData newTaskData;
    private final TaskData oldTaskData;
    private final Set<ITaskComment> newComments = new LinkedHashSet<ITaskComment>();
    private final Set<TaskAttributeDiff> changedAttributes = new LinkedHashSet<TaskAttributeDiff>();
    private final RepositoryModel repositoryModel;

    public TaskDataDiff(RepositoryModel repositoryModel, TaskData newTaskData, TaskData oldTaskData) {
        Assert.isNotNull((Object)repositoryModel);
        Assert.isNotNull((Object)newTaskData);
        this.repositoryModel = repositoryModel;
        this.newTaskData = newTaskData;
        this.oldTaskData = oldTaskData;
        this.parse();
    }

    public Collection<ITaskComment> getNewComments() {
        return this.newComments;
    }

    public Collection<TaskAttributeDiff> getChangedAttributes() {
        return this.changedAttributes;
    }

    private void parse() {
        String[] stringArray = this.ATTRIBUTES_IDS;
        int n = this.ATTRIBUTES_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeId = stringArray[n2];
            TaskAttribute newAttribute = this.newTaskData.getRoot().getMappedAttribute(attributeId);
            TaskAttribute oldAttribute = null;
            if (this.oldTaskData != null) {
                oldAttribute = this.oldTaskData.getRoot().getMappedAttribute(attributeId);
            }
            if (oldAttribute != null || newAttribute != null) {
                this.addChangedAttribute(oldAttribute, newAttribute, true);
            }
            ++n2;
        }
        for (TaskAttribute newAttribute : this.newTaskData.getRoot().getAttributes().values()) {
            TaskAttribute oldAttribute = null;
            if (this.oldTaskData != null) {
                oldAttribute = this.oldTaskData.getRoot().getMappedAttribute(newAttribute.getPath());
            }
            this.addChangedAttribute(oldAttribute, newAttribute, false);
        }
        if (this.oldTaskData != null) {
            for (TaskAttribute oldAttribute : this.oldTaskData.getRoot().getAttributes().values()) {
                TaskAttribute newAttribute = this.newTaskData.getRoot().getMappedAttribute(oldAttribute.getPath());
                if (newAttribute != null) continue;
                this.addChangedAttribute(oldAttribute, newAttribute, false);
            }
        }
    }

    private void addChangedAttribute(TaskAttribute oldAttribute, TaskAttribute newAttribute, boolean ignoreKind) {
        TaskAttributeDiff diff;
        TaskAttribute attribute = newAttribute != null ? newAttribute : oldAttribute;
        String type = attribute.getMetaData().getType();
        if ("comment".equals(type)) {
            this.addChangedComment(oldAttribute, newAttribute);
        } else if (!"operation".equals(type) && (ignoreKind || attribute.getMetaData().getKind() != null) && (diff = new TaskAttributeDiff(oldAttribute, newAttribute)).hasChanges()) {
            this.changedAttributes.add(diff);
        }
    }

    private void addChangedComment(TaskAttribute oldAttribute, TaskAttribute newAttribute) {
        ITaskComment comment;
        if (oldAttribute == null && (comment = this.repositoryModel.createTaskComment(newAttribute)) != null) {
            this.newComments.add(comment);
        }
    }

    public String toString() {
        return this.toString(60);
    }

    public String toString(int maxWidth) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        int newCommentCount = this.newComments.size();
        if (newCommentCount > 0) {
            ITaskComment comment = this.newComments.iterator().next();
            sb.append(TaskDiffUtil.trim(TaskDiffUtil.commentToString(comment), 60));
            if (newCommentCount > 1) {
                sb.append(" (" + (newCommentCount - 1) + " more)");
            }
            sep = "\n";
        }
        int n = 0;
        for (TaskAttributeDiff attributeDiff : this.changedAttributes) {
            String label = attributeDiff.getLabel();
            if (label == null) continue;
            sb.append(sep);
            sb.append(" ");
            sb.append(label);
            sb.append(" ");
            sb.append(TaskDiffUtil.trim(TaskDiffUtil.listToString(attributeDiff.getRemovedValues()), 28));
            sb.append(" -> ");
            sb.append(TaskDiffUtil.trim(TaskDiffUtil.listToString(attributeDiff.getAddedValues()), 28));
            if (++n == 2) break;
            sep = "\n";
        }
        return sb.toString();
    }
}

