/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.List;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDiffUtil {
    private static final String ELLIPSIS = "...";
    private static int DRAW_FLAGS = 15;

    public static String commentToString(ITaskComment comment) {
        StringBuilder sb = new StringBuilder();
        sb.append("Comment by ");
        sb.append(TaskDiffUtil.personToString(comment.getAuthor()));
        sb.append(": ");
        sb.append(TaskDiffUtil.cleanCommentText(comment.getText()));
        return sb.toString();
    }

    private static String personToString(IRepositoryPerson author) {
        if (author == null) {
            return "Unknown";
        }
        if (author.getName() != null) {
            return author.getName();
        }
        return author.getPersonId();
    }

    public static String cleanCommentText(String value) {
        String text = "";
        String[] lines = value.split("\n");
        boolean attachment = false;
        boolean needSeparator = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (attachment) {
                text = String.valueOf(text) + " attachment: " + line;
                needSeparator = true;
                attachment = false;
            } else if (line.startsWith(">") || line.matches("^\\s*\\(In reply to comment.*")) {
                needSeparator = true;
            } else if (line.startsWith("Created an attachment (id=")) {
                attachment = true;
            } else {
                if (needSeparator && !text.matches(".*\\p{Punct}\\s*") && (text = text.trim()).length() > 0) {
                    text = String.valueOf(text) + ".";
                }
                text = String.valueOf(text) + " " + line;
                attachment = false;
                needSeparator = false;
            }
            ++n2;
        }
        return TaskDiffUtil.foldSpaces(text);
    }

    public static String listToString(List<String> values) {
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(TaskDiffUtil.foldSpaces(value));
        }
        return sb.toString();
    }

    public static String foldSpaces(String value) {
        return value.replaceAll("\\s", " ").trim();
    }

    public static String trim(String value, int length) {
        if (value.length() > length) {
            value = String.valueOf(value.substring(0, length - 3)) + ELLIPSIS;
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public static final String shortenText2(Composite composite, String t, int width) {
        gc = new GC((Drawable)composite);
        if (t == null) {
            return null;
        }
        w = gc.textExtent((String)"...", (int)TaskDiffUtil.DRAW_FLAGS).x;
        if (width <= w) {
            return t;
        }
        l = t.length();
        max = l / 2;
        mid = (max + (min = 0)) / 2 - 1;
        if (mid > 0) ** GOTO lbl25
        return t;
lbl-1000:
        // 1 sources

        {
            s1 = t.substring(0, mid);
            s2 = t.substring(l - mid, l);
            l1 = gc.textExtent((String)s1, (int)TaskDiffUtil.DRAW_FLAGS).x;
            l2 = gc.textExtent((String)s2, (int)TaskDiffUtil.DRAW_FLAGS).x;
            if (l1 + w + l2 > width) {
                max = mid;
                mid = (max + min) / 2;
                continue;
            }
            if (l1 + w + l2 < width) {
                min = mid;
                mid = (max + min) / 2;
                continue;
            }
            min = max;
lbl25:
            // 4 sources

            ** while (min < mid && mid < max)
        }
lbl26:
        // 1 sources

        gc.dispose();
        if (mid == 0) {
            return t;
        }
        return String.valueOf(t.substring(0, mid)) + "..." + t.substring(l - mid, l);
    }

    public static String shortenText(Drawable composite, String text, int maxWidth) {
        String returnText = text;
        GC gc = new GC(composite);
        if (gc.textExtent((String)text).x > maxWidth) {
            int i = text.length();
            while (i > 0) {
                String subString = text.substring(0, i);
                subString = String.valueOf(subString) + ELLIPSIS;
                if (gc.textExtent((String)subString).x < maxWidth) {
                    returnText = subString;
                    break;
                }
                --i;
            }
        }
        gc.dispose();
        return returnText;
    }
}

