/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskDataStorageManager;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.FileAttachment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.ITaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.DownloadAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtil {
    protected static final int BUFFER_SIZE = 1024;
    private static final String CONTEXT_DESCRIPTION = "mylyn/context/zip";
    private static final String CONTEXT_DESCRIPTION_LEGACY = "mylar/context/zip";
    private static final String CONTEXT_FILENAME = "mylyn-context.zip";
    private static final String CONTEXT_CONTENT_TYPE = "application/octet-stream";
    private static final String MESSAGE_ATTACHMENTS_NOT_SUPPORTED = "Attachments not supported by connector: ";
    private static final String TITLE_DIALOG = "Mylyn Information";

    @Deprecated
    public static boolean attachContext(AbstractAttachmentHandler attachmentHandler, TaskRepository repository, ITask task, String longComment, IProgressMonitor monitor) throws CoreException {
        ContextCorePlugin.getContextStore().saveActiveContext();
        File sourceContextFile = ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
        ITask.SynchronizationState previousState = task.getSynchronizationState();
        if (sourceContextFile != null && sourceContextFile.exists()) {
            try {
                ((AbstractTask)task).setSubmitting(true);
                ((AbstractTask)task).setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                FileAttachment attachment = new FileAttachment(sourceContextFile);
                attachment.setDescription(CONTEXT_DESCRIPTION);
                attachment.setFilename(CONTEXT_FILENAME);
                attachmentHandler.uploadAttachment(repository, task, (ITaskAttachment)attachment, longComment, monitor);
            }
            catch (CoreException e) {
                ((AbstractTask)task).setSynchronizationState(previousState);
                throw e;
            }
            catch (OperationCanceledException operationCanceledException) {
                return true;
            }
        }
        return true;
    }

    public static boolean postContext(AbstractRepositoryConnector connector, TaskRepository repository, ITask task, String comment, TaskAttribute attribute, IProgressMonitor monitor) throws CoreException {
        AbstractTaskAttachmentHandler attachmentHandler = connector.getTaskAttachmentHandler();
        ContextCorePlugin.getContextStore().saveActiveContext();
        File file = ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
        if (attachmentHandler != null && file != null && file.exists()) {
            FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(file);
            attachment.setDescription(CONTEXT_DESCRIPTION);
            attachment.setName(CONTEXT_FILENAME);
            attachmentHandler.postContent(repository, task, (AbstractTaskAttachmentSource)attachment, comment, attribute, monitor);
            return true;
        }
        return false;
    }

    public static Set<RepositoryAttachment> getLegacyContextAttachments(TaskRepository repository, ITask task) {
        RepositoryTaskData newData;
        TaskDataStorageManager taskDataManager = TasksUiPlugin.getTaskDataStorageManager();
        HashSet<RepositoryAttachment> contextAttachments = new HashSet<RepositoryAttachment>();
        if (taskDataManager != null && (newData = taskDataManager.getNewTaskData(task.getRepositoryUrl(), task.getTaskId())) != null) {
            for (RepositoryAttachment attachment : newData.getAttachments()) {
                if (attachment.getDescription().equals(CONTEXT_DESCRIPTION)) {
                    contextAttachments.add(attachment);
                    continue;
                }
                if (!attachment.getDescription().equals(CONTEXT_DESCRIPTION_LEGACY)) continue;
                contextAttachments.add(attachment);
            }
        }
        return contextAttachments;
    }

    public static List<org.eclipse.mylyn.tasks.core.ITaskAttachment> getContextAttachments(TaskRepository repository, ITask task) {
        TaskData taskData;
        ArrayList<org.eclipse.mylyn.tasks.core.ITaskAttachment> contextAttachments = new ArrayList<org.eclipse.mylyn.tasks.core.ITaskAttachment>();
        try {
            taskData = TasksUi.getTaskDataManager().getTaskData(task);
        }
        catch (CoreException coreException) {
            return contextAttachments;
        }
        if (taskData != null) {
            List taskAttachments = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
            for (TaskAttribute attribute : taskAttachments) {
                TaskAttachment taskAttachment = new TaskAttachment(repository, task, attribute);
                taskData.getAttributeMapper().updateTaskAttachment((org.eclipse.mylyn.tasks.core.ITaskAttachment)taskAttachment, attribute);
                if (!AttachmentUtil.isContext((org.eclipse.mylyn.tasks.core.ITaskAttachment)taskAttachment)) continue;
                contextAttachments.add((org.eclipse.mylyn.tasks.core.ITaskAttachment)taskAttachment);
            }
        }
        return contextAttachments;
    }

    public static boolean hasContext(TaskRepository repository, ITask task) {
        if (repository == null || task == null) {
            return false;
        }
        Set<RepositoryAttachment> remoteContextAttachments = AttachmentUtil.getLegacyContextAttachments(repository, task);
        return remoteContextAttachments != null && remoteContextAttachments.size() > 0;
    }

    public static boolean hasContextAttachment(ITask task) {
        Assert.isNotNull((Object)task);
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (connector instanceof AbstractLegacyRepositoryConnector) {
            Set<RepositoryAttachment> remoteContextAttachments = AttachmentUtil.getLegacyContextAttachments(repository, task);
            return remoteContextAttachments != null && remoteContextAttachments.size() > 0;
        }
        List<org.eclipse.mylyn.tasks.core.ITaskAttachment> contextAttachments = AttachmentUtil.getContextAttachments(repository, task);
        return contextAttachments.size() > 0;
    }

    public static boolean downloadContext(ITask task, org.eclipse.mylyn.tasks.core.ITaskAttachment attachment, IRunnableContext context) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(attachment.getConnectorKind(), attachment.getRepositoryUrl());
        String directory = TasksUiPlugin.getDefault().getDataDirectory();
        if (task.isActive()) {
            TasksUi.getTaskActivityManager().deactivateTask(task);
        }
        boolean result = false;
        if (connector instanceof AbstractRepositoryConnector && connector.getTaskAttachmentHandler() != null) {
            result = AttachmentUtil.retrieveContext(connector.getTaskAttachmentHandler(), repository, task, attachment, directory, context);
        }
        if (!result) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)(MESSAGE_ATTACHMENTS_NOT_SUPPORTED + connector.getLabel()));
        } else {
            TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)task);
            TasksUi.getTaskActivityManager().activateTask(task);
        }
        return true;
    }

    public static boolean uploadContext(TaskRepository repository, ITask task, String comment, IRunnableContext context) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        ContextCorePlugin.getContextStore().saveActiveContext();
        File sourceContextFile = ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
        if (!sourceContextFile.exists()) {
            return false;
        }
        FileTaskAttachmentSource source = new FileTaskAttachmentSource(sourceContextFile);
        source.setDescription(CONTEXT_DESCRIPTION);
        source.setContentType(CONTEXT_CONTENT_TYPE);
        final SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskAttachmentJob(connector, repository, task, (AbstractTaskAttachmentSource)source, comment, null);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (((SubmitTaskAttachmentJob)submitJob).run(monitor) == Status.CANCEL_STATUS) {
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus(TITLE_DIALOG, ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while attaching context", (Throwable)e));
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean hasLocalContext(ITask task) {
        Assert.isNotNull((Object)task);
        return ContextCore.getContextManager().hasContext(task.getHandleIdentifier());
    }

    @Deprecated
    public static boolean isContext(RepositoryAttachment attachment) {
        return CONTEXT_DESCRIPTION.equals(attachment.getDescription()) || CONTEXT_DESCRIPTION_LEGACY.equals(attachment.getDescription());
    }

    public static boolean isContext(org.eclipse.mylyn.tasks.core.ITaskAttachment attachment) {
        return CONTEXT_DESCRIPTION.equals(attachment.getDescription()) || CONTEXT_DESCRIPTION_LEGACY.equals(attachment.getDescription());
    }

    public static boolean retrieveContext(AbstractTaskAttachmentHandler attachmentHandler, TaskRepository repository, ITask task, org.eclipse.mylyn.tasks.core.ITaskAttachment attachment, String destinationPath, IRunnableContext context) {
        File destinationContextFile = ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
        if (destinationContextFile.exists() && !destinationContextFile.delete()) {
            return false;
        }
        final DownloadAttachmentJob downloadJob = new DownloadAttachmentJob(attachment, destinationContextFile);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (downloadJob.run(monitor) == Status.CANCEL_STATUS) {
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus(TITLE_DIALOG, ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while retrieving context", (Throwable)e));
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean canUploadAttachment(ITask task) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (connector instanceof AbstractLegacyRepositoryConnector) {
            AbstractAttachmentHandler attachmentHandler = ((AbstractLegacyRepositoryConnector)connector).getAttachmentHandler();
            if (attachmentHandler != null) {
                return attachmentHandler.canUploadAttachment(repository, task);
            }
        } else {
            AbstractTaskAttachmentHandler attachmentHandler = connector.getTaskAttachmentHandler();
            if (attachmentHandler != null) {
                return attachmentHandler.canPostContent(repository, task);
            }
        }
        return false;
    }

    public static boolean canDownloadAttachment(ITask task) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (connector instanceof AbstractLegacyRepositoryConnector) {
            AbstractAttachmentHandler attachmentHandler = ((AbstractLegacyRepositoryConnector)connector).getAttachmentHandler();
            if (attachmentHandler != null) {
                return attachmentHandler.canDownloadAttachment(repository, task);
            }
        } else {
            AbstractTaskAttachmentHandler attachmentHandler = connector.getTaskAttachmentHandler();
            if (attachmentHandler != null) {
                return attachmentHandler.canGetContent(repository, task);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadAttachment(org.eclipse.mylyn.tasks.core.ITaskAttachment attachment, OutputStream out, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Downloading attachment", -1);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(attachment.getConnectorKind());
            AbstractTaskAttachmentHandler handler = connector.getTaskAttachmentHandler();
            if (handler == null) {
                throw new CoreException((IStatus)new RepositoryStatus(1, "org.eclipse.mylyn.tasks.ui", 7, "The repository does not support attachments."));
            }
            InputStream in = handler.getContent(attachment.getTaskRepository(), attachment.getTask(), attachment.getTaskAttribute(), monitor);
            try {
                byte[] buffer = new byte[1024];
                while (true) {
                    Policy.checkCanceled((IProgressMonitor)monitor);
                    int count = in.read(buffer);
                    if (count == -1) {
                        return;
                    }
                    out.write(buffer, 0, count);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new RepositoryStatus(attachment.getTaskRepository(), 4, "org.eclipse.mylyn.tasks.ui", 5, "IO error reading attachment: " + e.getMessage(), (Throwable)e));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error closing attachment stream", (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

