/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;

public class DownloadAttachmentJob
extends Job {
    private final ITaskAttachment attachment;
    private final File targetFile;

    public DownloadAttachmentJob(ITaskAttachment attachment, File targetFile) {
        super("Downloading Attachment");
        this.attachment = attachment;
        this.targetFile = targetFile;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.targetFile));
                try {
                    AttachmentUtil.downloadAttachment(this.attachment, out, monitor);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new RepositoryStatus(this.attachment.getTaskRepository(), 4, "org.eclipse.mylyn.tasks.ui", 5, "IO error writing attachment: " + e.getMessage(), (Throwable)e));
            }
        }
        catch (CoreException e) {
            TasksUiInternal.asyncDisplayStatus("Copy Attachment to Clipboard", e.getStatus());
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }
}

