/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataExportOperation
implements IRunnableWithProgress {
    private static final String JOB_LABEL = "Exporting Mylyn Task Data";
    private final boolean zip;
    private final boolean exportTaskList;
    private final boolean exportActivationHistory;
    private final boolean exportTaskContexts;
    private final String destinationDirectory;
    private final String zipFileName;
    private File destZipFile = null;
    private final Collection<AbstractTask> tasks;

    public TaskDataExportOperation(String destinationDirectory, boolean zipIt, String zipFileName) {
        this(destinationDirectory, true, true, true, zipIt, zipFileName, TasksUiPlugin.getTaskList().getAllTasks());
    }

    public TaskDataExportOperation(String destinationDirectory, boolean exportTaskList, boolean exportActivationHistory, boolean exportTaskContexts, boolean zipIt, String zipFileName, Collection<AbstractTask> taskContextsToExport) {
        this.zipFileName = zipFileName;
        this.zip = zipIt;
        this.exportTaskList = exportTaskList;
        this.exportActivationHistory = exportActivationHistory;
        this.exportTaskContexts = exportTaskContexts;
        this.destinationDirectory = destinationDirectory;
        this.tasks = taskContextsToExport;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int jobSize = 1;
        if (this.exportTaskList) {
            ++jobSize;
        }
        if (this.exportActivationHistory) {
            ++jobSize;
        }
        if (this.exportTaskContexts) {
            jobSize += this.tasks.size();
        }
        ArrayList<File> filesToZip = new ArrayList<File>();
        HashMap filesToZipMap = new HashMap();
        try {
            String sourceTaskListPath;
            File file;
            monitor.beginTask(JOB_LABEL, jobSize);
            Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, monitor);
            String sourceContextsPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "contexts";
            File contextsDirectory = new File(sourceContextsPath);
            String sourceRepositoriesPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "repositories.xml.zip";
            File file2 = new File(sourceRepositoriesPath);
            if (file2.exists()) {
                File destRepositoriesFile = new File(String.valueOf(this.destinationDirectory) + File.separator + "repositories.xml.zip");
                if (this.zip) {
                    filesToZip.add(file2);
                } else if (!destRepositoriesFile.equals(file2)) {
                    if (destRepositoriesFile.exists()) {
                        destRepositoriesFile.delete();
                    }
                    if (!this.copy(file2, destRepositoriesFile)) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export repositories file", (Throwable)new Exception()));
                    }
                    monitor.worked(1);
                }
            }
            if (this.exportTaskList && (file = new File(sourceTaskListPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "tasks.xml.zip")).exists()) {
                File destTaskListFile = new File(String.valueOf(this.destinationDirectory) + File.separator + "tasks.xml.zip");
                if (this.zip) {
                    filesToZip.add(file);
                } else if (!destTaskListFile.equals(file)) {
                    if (destTaskListFile.exists()) {
                        destTaskListFile.delete();
                    }
                    if (!this.copy(file, destTaskListFile)) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export task list file", (Throwable)new Exception()));
                    }
                    monitor.worked(1);
                }
            }
            if (this.exportActivationHistory) {
                try {
                    File sourceActivationHistoryFile = new File(contextsDirectory, "activity.xml.zip");
                    if (sourceActivationHistoryFile.exists()) {
                        File file3 = new File(String.valueOf(this.destinationDirectory) + File.separator + "activity" + ".xml.zip");
                        if (this.zip) {
                            filesToZip.add(sourceActivationHistoryFile);
                        } else if (!file3.equals(sourceActivationHistoryFile)) {
                            if (file3.exists()) {
                                file3.delete();
                            }
                            this.copy(sourceActivationHistoryFile, file3);
                            monitor.worked(1);
                        }
                    }
                }
                catch (RuntimeException e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export activity history context file", (Throwable)e));
                }
            }
            if (this.exportTaskContexts) {
                boolean errorDisplayed = false;
                for (ITask iTask : this.tasks) {
                    if (!ContextCore.getContextManager().hasContext(iTask.getHandleIdentifier())) continue;
                    File sourceTaskContextFile = ContextCorePlugin.getContextStore().getFileForContext(iTask.getHandleIdentifier());
                    File destTaskFile = new File(String.valueOf(this.destinationDirectory) + File.separator + sourceTaskContextFile.getName());
                    if (this.zip) {
                        if (filesToZipMap.containsKey(iTask.getHandleIdentifier())) continue;
                        filesToZip.add(sourceTaskContextFile);
                        filesToZipMap.put(iTask.getHandleIdentifier(), null);
                        continue;
                    }
                    if (sourceTaskContextFile.equals(destTaskFile)) continue;
                    if (destTaskFile.exists()) {
                        destTaskFile.delete();
                    }
                    if (!this.copy(sourceTaskContextFile, destTaskFile) && !errorDisplayed) {
                        Exception e = new Exception("Export Exception: " + sourceTaskContextFile.getPath() + " -> " + destTaskFile.getPath());
                        StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export one or more task context files", (Throwable)e));
                        errorDisplayed = true;
                    }
                    monitor.worked(1);
                }
            }
            if (this.zip && filesToZip.size() > 0) {
                try {
                    this.destZipFile = new File(String.valueOf(this.destinationDirectory) + File.separator + this.zipFileName);
                    if (this.destZipFile.exists()) {
                        this.destZipFile.delete();
                    }
                    ZipFileUtil.createZipFile((File)this.destZipFile, filesToZip, (String)TasksUiPlugin.getDefault().getDataDirectory(), (IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create zip file", (Throwable)e));
                }
            }
        }
        finally {
            Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
            monitor.done();
        }
    }

    private boolean copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

