/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskDataStorageManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.CategoryEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.util.WebBrowserDialog;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiInternal {
    public static final int SWT_NO_SCROLL = 16;

    public static MultiRepositoryAwareWizard createNewTaskWizard(ITaskMapping taskSelection) {
        return new NewTaskWizard(taskSelection);
    }

    public static ImageDescriptor getPriorityImage(ITask task) {
        if (task.isCompleted()) {
            return CommonImages.COMPLETE;
        }
        return TasksUiImages.getImageDescriptorForPriority(ITask.PriorityLevel.fromString((String)task.getPriority()));
    }

    public static List<TaskEditor> getActiveRepositoryTaskEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<TaskEditor> repositoryTaskEditors = new ArrayList<TaskEditor>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorReferences;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IEditorReference[] iEditorReferenceArray = editorReferences = window.getActivePage().getEditorReferences();
            int n3 = editorReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editorReference = iEditorReferenceArray[n4];
                try {
                    IEditorPart editorPart;
                    TaskEditorInput input;
                    if (editorReference.getEditorInput() instanceof TaskEditorInput && (input = (TaskEditorInput)editorReference.getEditorInput()).getTask() != null && (editorPart = editorReference.getEditor(false)) instanceof TaskEditor) {
                        repositoryTaskEditors.add((TaskEditor)editorPart);
                    }
                }
                catch (PartInitException partInitException) {}
                ++n4;
            }
            ++n2;
        }
        return repositoryTaskEditors;
    }

    public static IProgressMonitor getUiMonitor(IProgressMonitor monitor) {
        return new ProgressMonitorWrapper(monitor){

            public void beginTask(final String name, final int totalWork) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        this.getWrappedProgressMonitor().beginTask(name, totalWork);
                    }
                });
            }

            public void done() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        this.getWrappedProgressMonitor().done();
                    }
                });
            }

            public void subTask(final String name) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        this.getWrappedProgressMonitor().subTask(name);
                    }
                });
            }

            public void worked(final int work) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        this.getWrappedProgressMonitor().worked(work);
                    }
                });
            }
        };
    }

    public static void openEditor(TaskCategory category) {
        final CategoryEditorInput input = new CategoryEditorInput(category);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    TasksUiUtil.openEditor(input, "org.eclipse.mylyn.tasks.ui.editors.category", page);
                }
            }
        });
    }

    public static void refreshAndOpenTaskListElement(IRepositoryElement element) {
        if (element instanceof ITask) {
            final AbstractTask task = (AbstractTask)element;
            if (task instanceof LocalTask) {
                TasksUiUtil.openTask((ITask)task);
            } else {
                String repositoryKind = task.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryKind);
                TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, task.getRepositoryUrl());
                if (repository == null) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "No repository found for task. Please create repository in Task Repositories."));
                    return;
                }
                if (connector != null) {
                    boolean opened = false;
                    if (connector instanceof AbstractLegacyRepositoryConnector) {
                        RepositoryTaskData taskData = TasksUiPlugin.getTaskDataStorageManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
                        if (taskData != null || connector.getTaskDataHandler() == null) {
                            TasksUiUtil.openTask((ITask)task);
                            opened = true;
                        }
                    } else if (TasksUiPlugin.getTaskDataManager().hasTaskData((ITask)task)) {
                        opened = TasksUiUtil.openTask((ITask)task);
                    }
                    if (!opened) {
                        if (connector.canSynchronizeTask(repository, (ITask)task)) {
                            TasksUiInternal.synchronizeTask(connector, (ITask)task, true, (IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            TasksUiUtil.openTask((ITask)task);
                                        }
                                    });
                                }
                            });
                        } else {
                            TasksUiUtil.openTask((ITask)task);
                        }
                    }
                }
            }
        } else if (element instanceof TaskCategory) {
            TasksUiInternal.openEditor((TaskCategory)element);
        } else if (element instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)element;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getConnectorKind());
            TasksUiInternal.openEditQueryDialog(connectorUi, (IRepositoryQuery)query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskJob updateRepositoryConfiguration(final TaskRepository taskRepository) {
        TaskRepository taskRepository2 = taskRepository;
        synchronized (taskRepository2) {
            taskRepository.setUpdating(true);
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        final TaskJob job = TasksUiInternal.getJobFactory().createUpdateRepositoryConfigurationJob(connector, taskRepository);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Display display;
                TaskRepository taskRepository2 = taskRepository;
                synchronized (taskRepository2) {
                    taskRepository.setUpdating(false);
                }
                if (job.getStatus() != null && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed()) {
                    TasksUiInternal.displayStatus("Configuration Refresh Failed", job.getStatus());
                }
            }
        });
        job.schedule();
        return job;
    }

    private static void joinIfInTestMode(SynchronizationJob job) {
        if (CoreUtil.TEST_MODE) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final Job synchronizeQueries(AbstractRepositoryConnector connector, TaskRepository repository, Set<RepositoryQuery> queries, IJobChangeListener listener, boolean force) {
        Assert.isTrue((queries.size() > 0 ? 1 : 0) != 0);
        TaskList taskList = TasksUiPlugin.getTaskList();
        for (RepositoryQuery query : queries) {
            query.setSynchronizing(true);
        }
        taskList.notifySynchronizationStateChanged(queries);
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeQueriesJob(connector, repository, queries);
        job.setUser(force);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        if (force) {
            final RepositoryQuery query = queries.iterator().next();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (query.getStatus() != null) {
                        TasksUiInternal.asyncDisplayStatus("Query Synchronization Failed", query.getStatus());
                    }
                }
            });
        }
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static final Job synchronizeQuery(AbstractRepositoryConnector connector, RepositoryQuery repositoryQuery, IJobChangeListener listener, boolean force) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryQuery.getConnectorKind(), repositoryQuery.getRepositoryUrl());
        return TasksUiInternal.synchronizeQueries(connector, repository, Collections.singleton(repositoryQuery), listener, force);
    }

    public static SynchronizationJob synchronizeAllRepositories(boolean force) {
        HashSet<TaskRepository> repositories = new HashSet<TaskRepository>(TasksUi.getRepositoryManager().getAllRepositories());
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeRepositoriesJob(repositories);
        job.setUser(force);
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static SynchronizationJob synchronizeRepository(TaskRepository repository, boolean force) {
        return TasksUiPlugin.getSynchronizationScheduler().synchronize(repository);
    }

    public static Job synchronizeTask(AbstractRepositoryConnector connector, ITask task, boolean force, IJobChangeListener listener) {
        return TasksUiInternal.synchronizeTasks(connector, Collections.singleton(task), force, listener);
    }

    public static Job synchronizeTasks(AbstractRepositoryConnector connector, Set<ITask> tasks, boolean force, IJobChangeListener listener) {
        ITaskList taskList = TasksUiInternal.getTaskList();
        for (ITask task : tasks) {
            ((AbstractTask)task).setSynchronizing(true);
        }
        ((TaskList)taskList).notifySynchronizationStateChanged(tasks);
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeTasksJob(connector, tasks);
        job.setUser(force);
        job.setPriority(50);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        if (force && tasks.size() == 1) {
            final ITask task = tasks.iterator().next();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (task instanceof AbstractTask && ((AbstractTask)task).getStatus() != null) {
                        TasksUiInternal.asyncDisplayStatus("Task Synchronization Failed", ((AbstractTask)task).getStatus());
                    }
                }
            });
        }
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static ITaskJobFactory getJobFactory() {
        return TasksUiPlugin.getTaskJobFactory();
    }

    public static NewAttachmentWizardDialog openNewAttachmentWizard(Shell shell, TaskRepository taskRepository, ITask task, TaskAttribute taskAttribute, TaskAttachmentWizard.Mode mode, AbstractTaskAttachmentSource source) {
        TaskAttachmentWizard attachmentWizard = new TaskAttachmentWizard(taskRepository, task, taskAttribute);
        attachmentWizard.setSource(source);
        attachmentWizard.setMode(mode);
        NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(shell, (IWizard)attachmentWizard, false);
        dialog.setBlockOnOpen(false);
        dialog.create();
        dialog.open();
        return dialog;
    }

    private static MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    public static void displayStatus(Shell shell, String title, IStatus status) {
        if (status.getCode() == 7) {
            StatusHandler.fail((IStatus)status);
        } else if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
            WebBrowserDialog.openAcceptAgreement(shell, title, status.getMessage(), ((RepositoryStatus)status).getHtmlMessage());
        } else {
            switch (status.getSeverity()) {
                case 1: 
                case 8: {
                    TasksUiInternal.createDialog(shell, title, status.getMessage(), 2).open();
                    break;
                }
                case 2: {
                    TasksUiInternal.createDialog(shell, title, status.getMessage(), 4).open();
                    break;
                }
                default: {
                    TasksUiInternal.createDialog(shell, title, status.getMessage(), 1).open();
                }
            }
        }
    }

    public static void asyncDisplayStatus(final String title, final IStatus status) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    TasksUiInternal.displayStatus(title, status);
                }
            });
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static void displayStatus(String title, IStatus status) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            TasksUiInternal.displayStatus(TasksUiInternal.getShell(), title, status);
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static LocalTask createNewLocalTask(String summary) {
        if (summary == null) {
            summary = "New Task";
        }
        TaskList taskList = TasksUiPlugin.getTaskList();
        LocalTask newTask = new LocalTask("" + taskList.getNextLocalTaskId(), summary);
        newTask.setPriority(ITask.PriorityLevel.P3.toString());
        TasksUiInternal.getTaskList().addTask((ITask)newTask);
        TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)newTask);
        Object selectedObject = null;
        TaskListView view = TaskListView.getFromActivePerspective();
        if (view != null) {
            selectedObject = ((IStructuredSelection)view.getViewer().getSelection()).getFirstElement();
        }
        if (selectedObject instanceof TaskCategory) {
            taskList.addTask((ITask)newTask, (AbstractTaskContainer)((TaskCategory)selectedObject));
        } else if (selectedObject instanceof ITask) {
            ITask task = (ITask)selectedObject;
            AbstractTaskCategory container = TaskCategory.getParentTaskCategory((ITask)task);
            if (container instanceof TaskCategory) {
                taskList.addTask((ITask)newTask, (AbstractTaskContainer)container);
            } else if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
                taskList.addTask((ITask)newTask, view.getDrilledIntoCategory());
            } else {
                taskList.addTask((ITask)newTask, (AbstractTaskContainer)TasksUiPlugin.getTaskList().getDefaultCategory());
            }
        } else if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
            taskList.addTask((ITask)newTask, view.getDrilledIntoCategory());
        } else {
            if (view != null && view.getDrilledIntoCategory() != null) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Create Task", (String)"The new task has been added to the root of the list, since tasks can not be added to a query.");
            }
            taskList.addTask((ITask)newTask, (AbstractTaskContainer)TasksUiPlugin.getTaskList().getDefaultCategory());
        }
        return newTask;
    }

    public static Set<AbstractTaskContainer> getContainersFromWorkingSet(Set<IWorkingSet> containers) {
        HashSet<AbstractTaskContainer> allTaskContainersInWorkingSets = new HashSet<AbstractTaskContainer>();
        for (IWorkingSet workingSet : containers) {
            IAdaptable[] elements;
            IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (adaptable instanceof AbstractTaskContainer) {
                    allTaskContainersInWorkingSets.add((AbstractTaskContainer)adaptable);
                }
                ++n2;
            }
        }
        return allTaskContainersInWorkingSets;
    }

    public static void openEditQueryDialog(AbstractRepositoryConnectorUi connectorUi, IRepositoryQuery query) {
        try {
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            if (repository == null) {
                return;
            }
            IWizard wizard = connectorUi.getQueryWizard(repository, query);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (wizard != null && shell != null && !shell.isDisposed()) {
                WizardDialog dialog = new WizardDialog(shell, wizard);
                dialog.create();
                dialog.setTitle("Edit Repository Query");
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    dialog.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open query dialog", (Throwable)e));
        }
    }

    public static ITaskList getTaskList() {
        return TasksUiPlugin.getTaskList();
    }

    public static boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public static boolean hasValidUrl(ITask task) {
        return TasksUiInternal.isValidUrl(task.getUrl());
    }

    public static boolean isValidUrl(String url) {
        if (!(url == null || url.equals("") || url.equals("http://") || url.equals("https://"))) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public static void closeEditorInActivePage(ITask task, boolean save) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        TaskEditorInput input = new TaskEditorInput(taskRepository, task);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.closeEditor(editor, save);
        }
    }

    public static ITask createTask(TaskRepository repository, String id, IProgressMonitor monitor) throws CoreException {
        RepositoryTaskData taskData;
        AbstractRepositoryConnector connector;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        ITaskList taskList = TasksUiInternal.getTaskList();
        AbstractTask task = (AbstractTask)taskList.getTask(repository.getRepositoryUrl(), id);
        if (task == null && (connector = TasksUiPlugin.getConnector(repository.getConnectorKind())) instanceof AbstractLegacyRepositoryConnector && (taskData = ((AbstractLegacyRepositoryConnector)connector).getLegacyTaskData(repository, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null && (task = TasksUiInternal.createTaskFromTaskData((AbstractLegacyRepositoryConnector)connector, taskList, repository, taskData, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
            task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
            taskList.addTask((ITask)task);
        }
        return task;
    }

    public static AbstractTask createTaskFromExistingId(AbstractLegacyRepositoryConnector connector, ITaskList taskList, TaskRepository repository, String id, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        RepositoryTaskData taskData;
        AbstractTask task = (AbstractTask)taskList.getTask(repository.getRepositoryUrl(), id);
        if (task == null && (taskData = connector.getLegacyTaskData(repository, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null && (task = TasksUiInternal.createTaskFromTaskData(connector, taskList, repository, taskData, retrieveSubTasks, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
            task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
            taskList.addTask((ITask)task);
        }
        return task;
    }

    private static AbstractTask createTaskFromTaskData(AbstractLegacyRepositoryConnector connector, ITaskList taskList, TaskRepository repository, RepositoryTaskData taskData, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractTask task = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            TaskDataStorageManager taskDataManager = TasksUiPlugin.getTaskDataStorageManager();
            if (taskData != null) {
                task = connector.createTask(repository.getRepositoryUrl(), taskData.getTaskId(), String.valueOf(taskData.getTaskId()) + ": " + taskData.getDescription());
                connector.updateTaskFromTaskData(repository, (ITask)task, taskData);
                taskDataManager.setNewTaskData(taskData);
                if (retrieveSubTasks) {
                    monitor.beginTask("Creating task", connector.getLegacyTaskDataHandler().getSubTaskIds(taskData).size());
                    for (String subId : connector.getLegacyTaskDataHandler().getSubTaskIds(taskData)) {
                        AbstractTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = TasksUiInternal.createTaskFromExistingId(connector, taskList, repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        taskList.addTask((ITask)subTask, (AbstractTaskContainer)task);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return task;
    }

    public static void importTasks(Collection<AbstractTask> tasks, Set<TaskRepository> repositories, File zipFile, Shell shell) {
        TasksUiPlugin.getRepositoryManager().insertRepositories(repositories, TasksUiPlugin.getDefault().getRepositoriesFilePath());
        for (AbstractTask loadedTask : tasks) {
            loadedTask.setActive(false);
            TaskList taskList = TasksUiPlugin.getTaskList();
            try {
                if (taskList.getTask(loadedTask.getHandleIdentifier()) != null) {
                    boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)"Import Task", (String)("Task '" + loadedTask.getSummary() + "' already exists. Do you want to override it's context with the source?"));
                    if (!confirmed) continue;
                    ContextCore.getContextStore().importContext(loadedTask.getHandleIdentifier(), zipFile);
                    continue;
                }
                ContextCore.getContextStore().importContext(loadedTask.getHandleIdentifier(), zipFile);
                TasksUiInternal.getTaskList().addTask((ITask)loadedTask);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "Task context not found for import", (Throwable)e));
            }
        }
    }

    public static boolean hasLocalCompletionState(ITask task) {
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        return connector.hasLocalCompletionState(taskRepository, task);
    }

    private static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static Shell getShell() {
        Shell modal = TasksUiInternal.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return TasksUiInternal.getNonModalShell();
    }

    private static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static TaskData createTaskData(TaskRepository taskRepository, ITaskMapping initializationData, ITaskMapping selectionData, IProgressMonitor monitor) throws CoreException {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(taskRepository);
        TaskData taskData = new TaskData(mapper, taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), "");
        taskDataHandler.initializeTaskData(taskRepository, taskData, initializationData, monitor);
        if (selectionData != null) {
            connector.getTaskMapping(taskData).merge(selectionData);
        }
        return taskData;
    }

    public static void createAndOpenNewTask(TaskData taskData) throws CoreException {
        ITask task = TasksUiUtil.createOutgoingNewTask(taskData.getConnectorKind(), taskData.getRepositoryUrl());
        UnsubmittedTaskContainer unsubmitted = ((TaskList)TasksUiInternal.getTaskList()).getUnsubmittedContainer(taskData.getRepositoryUrl());
        if (unsubmitted != null) {
            TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)unsubmitted);
        }
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(task, taskData);
        workingCopy.save(null, null);
        TaskRepository localTaskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        TaskEditorInput editorInput = new TaskEditorInput(localTaskRepository, task);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", page);
    }

    public static boolean openRepositoryTask(String connectorKind, String repositoryUrl, String id) {
        IWorkbenchWindow[] windows;
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(connectorKind);
        String taskUrl = connector.getTaskUrl(repositoryUrl, id);
        if (taskUrl == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && windows.length > 0) {
            window = windows[0];
        }
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        OpenRepositoryTaskJob job = new OpenRepositoryTaskJob(connectorKind, repositoryUrl, id, taskUrl, page);
        job.schedule();
        return true;
    }

    public static boolean openTaskInBackground(ITask task, boolean bringToTop) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            boolean opened;
            IEditorPart activeEditor = null;
            IWorkbenchPart activePart = null;
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage != null) {
                activeEditor = activePage.getActiveEditor();
                activePart = activePage.getActivePart();
            }
            if ((opened = TasksUiUtil.openTask(task)) && activePage != null) {
                if (!bringToTop && activeEditor != null) {
                    activePage.bringToTop((IWorkbenchPart)activeEditor);
                }
                if (activePart != null) {
                    activePage.activate(activePart);
                }
            }
            return opened;
        }
        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + task.getSummary() + "\": no active workbench window"));
        return false;
    }
}

