/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.text.DateFormat;
import java.util.SortedMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TaskDataImportWizardPage
extends WizardPage {
    private static final String LABEL_IMPORT_ZIP = "From zip file";
    private static final String LABEL_IMPORT_BACKUP = "From snapshot";
    private static final String PAGE_TITLE = "Import Task Data";
    private static final String MESSAGE_WARNING = "Importing overwrites current tasks and repositories.  Consider exporting first.";
    public static final String PAGE_NAME = "Import Task Data";
    private Button taskListCheckBox = null;
    private Button taskActivationHistoryCheckBox = null;
    private Button taskContextsCheckBox = null;
    private Button browseButtonZip = null;
    private Text sourceZipText = null;
    private Button overwriteCheckBox = null;
    private Button importViaBackupButton;
    private Button importViaZipButton;
    private Table backupFilesTable;
    private static final String SETTINGS_SAVED = "Import Settings saved";
    private static final String TASKLIST_SETTING = "Import TaskList setting";
    private static final String ACTIVATION_HISTORY_SETTING = "Import Activation history setting";
    private static final String CONTEXTS_SETTING = "Import Contexts setting";
    private static final String SOURCE_ZIP_SETTING = "Import Source zip file setting";
    private static final String OVERWRITE_SETTING = "Import Overwrite setting";
    private static final String IMPORT_ZIPMETHOD_SETTING = "Import method zip";
    private static final String IMPORT_BACKUPMETHOD_SETTING = "Import method backup";

    public TaskDataImportWizardPage() {
        super("org.eclipse.mylyn.tasklist.importPage", "Import Task Data", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.tasks.ui", (String)"icons/wizban/banner-import.gif"));
        this.setPageComplete(false);
        this.setMessage(MESSAGE_WARNING, 2);
        this.setImageDescriptor(CommonImages.BANNER_IMPORT);
    }

    public String getName() {
        return "Import Task Data";
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = 15;
            container.setLayout((Layout)layout);
            this.createContentSelectionControl(container);
            this.createImportFromZipControl(container);
            this.createImportFromBackupControl(container);
            this.addRadioListeners();
            this.initSettings();
            this.setControl((Control)container);
            this.setPageComplete(this.validate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create import wizard page", (Throwable)e));
        }
    }

    private void addRadioListeners() {
        SelectionListener radioListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.browseButtonZip.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.backupFilesTable.setEnabled(TaskDataImportWizardPage.this.importViaBackupButton.getSelection());
                TaskDataImportWizardPage.this.sourceZipText.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.importViaZipButton.addSelectionListener(radioListener);
        this.importViaBackupButton.addSelectionListener(radioListener);
    }

    private void createContentSelectionControl(Composite parent) {
        Group group = new Group(parent, 16);
        GridLayout gl = new GridLayout(2, true);
        group.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, false).span(3, -1).applyTo((Control)group);
        group.setText("Select data to import:");
        this.taskListCheckBox = this.createCheckBox((Composite)group, "Task List and Repositories");
        this.taskActivationHistoryCheckBox = this.createCheckBox((Composite)group, "Task Activity History");
        this.taskContextsCheckBox = this.createCheckBox((Composite)group, "Task Contexts");
        this.overwriteCheckBox = this.createCheckBox((Composite)group, "Overwrite existing files without warning");
    }

    private void createImportFromZipControl(Composite parent) {
        this.importViaZipButton = new Button(parent, 16);
        this.importViaZipButton.setText(LABEL_IMPORT_ZIP);
        this.sourceZipText = new Text(parent, 2048);
        this.sourceZipText.setEditable(true);
        GridDataFactory.fillDefaults().grab(true, false).hint(250, -1).applyTo((Control)this.sourceZipText);
        this.sourceZipText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
        this.browseButtonZip = new Button(parent, 8);
        this.browseButtonZip.setText("Browse...");
        this.browseButtonZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TaskDataImportWizardPage.this.getShell());
                dialog.setText("Zip File Selection");
                String dir = TaskDataImportWizardPage.this.sourceZipText.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TaskDataImportWizardPage.this.sourceZipText.setText(dir);
            }
        });
    }

    private void createImportFromBackupControl(Composite container) {
        this.importViaBackupButton = new Button(container, 16);
        this.importViaBackupButton.setText(LABEL_IMPORT_BACKUP);
        this.addBackupFileView(container);
    }

    private void addBackupFileView(Composite composite) {
        this.backupFilesTable = new Table(composite, 2048);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).applyTo((Control)this.backupFilesTable);
        TableColumn filenameColumn = new TableColumn(this.backupFilesTable, 16384);
        filenameColumn.setWidth(200);
        SortedMap<Long, File> backupFilesMap = TasksUiPlugin.getBackupManager().getBackupFiles();
        for (Long time : backupFilesMap.keySet()) {
            File file = (File)backupFilesMap.get(time);
            TableItem item = new TableItem(this.backupFilesTable, 0);
            item.setData((Object)file.getAbsolutePath());
            item.setText(DateFormat.getDateTimeInstance().format(time));
        }
        this.backupFilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(SETTINGS_SAVED) == null) {
            this.taskListCheckBox.setSelection(true);
            this.taskActivationHistoryCheckBox.setSelection(true);
            this.taskContextsCheckBox.setSelection(true);
            this.overwriteCheckBox.setSelection(true);
            this.importViaZipButton.setSelection(true);
            this.sourceZipText.setEnabled(true);
            this.backupFilesTable.setEnabled(false);
        } else {
            this.taskListCheckBox.setSelection(settings.getBoolean(TASKLIST_SETTING));
            this.taskActivationHistoryCheckBox.setSelection(settings.getBoolean(ACTIVATION_HISTORY_SETTING));
            this.taskContextsCheckBox.setSelection(settings.getBoolean(CONTEXTS_SETTING));
            this.importViaZipButton.setSelection(settings.getBoolean(IMPORT_ZIPMETHOD_SETTING));
            this.importViaBackupButton.setSelection(settings.getBoolean(IMPORT_BACKUPMETHOD_SETTING));
            this.browseButtonZip.setEnabled(this.importViaZipButton.getSelection());
            this.sourceZipText.setEnabled(this.importViaZipButton.getSelection());
            this.backupFilesTable.setEnabled(this.importViaBackupButton.getSelection());
            String zipFile = settings.get(SOURCE_ZIP_SETTING);
            if (zipFile != null) {
                this.sourceZipText.setText(settings.get(SOURCE_ZIP_SETTING));
            }
            this.overwriteCheckBox.setSelection(settings.getBoolean(OVERWRITE_SETTING));
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(TASKLIST_SETTING, this.taskListCheckBox.getSelection());
        settings.put(ACTIVATION_HISTORY_SETTING, this.taskActivationHistoryCheckBox.getSelection());
        settings.put(CONTEXTS_SETTING, this.taskContextsCheckBox.getSelection());
        settings.put(SOURCE_ZIP_SETTING, this.sourceZipText.getText());
        settings.put(OVERWRITE_SETTING, this.overwriteCheckBox.getSelection());
        settings.put(IMPORT_ZIPMETHOD_SETTING, this.importViaZipButton.getSelection());
        settings.put(IMPORT_BACKUPMETHOD_SETTING, this.importViaBackupButton.getSelection());
        settings.put(SETTINGS_SAVED, SETTINGS_SAVED);
    }

    protected Button createCheckBox(Composite parent, String text) {
        Button newButton = new Button(parent, 32);
        newButton.setText(text);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return newButton;
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        if (!(this.taskListCheckBox.getSelection() || this.taskActivationHistoryCheckBox.getSelection() || this.taskContextsCheckBox.getSelection())) {
            return false;
        }
        if (this.importViaZipButton.getSelection() && this.sourceZipText.getText().equals("")) {
            return false;
        }
        return !this.importViaBackupButton.getSelection() || this.backupFilesTable.getSelection().length != 0;
    }

    public String getSourceZipFile() {
        if (this.importViaZipButton.getSelection()) {
            return this.sourceZipText.getText();
        }
        if (this.backupFilesTable.getSelectionIndex() != -1) {
            return (String)this.backupFilesTable.getSelection()[0].getData();
        }
        return "<unspecified>";
    }

    public boolean importTaskList() {
        return this.taskListCheckBox.getSelection();
    }

    public boolean importActivationHistory() {
        return this.taskActivationHistoryCheckBox.getSelection();
    }

    public boolean importTaskContexts() {
        return this.taskContextsCheckBox.getSelection();
    }

    public boolean overwrite() {
        return this.overwriteCheckBox.getSelection();
    }

    public boolean zip() {
        return true;
    }

    public void setParameters(boolean overwrite, boolean importTaskList, boolean importActivationHistory, boolean importTaskContexts, boolean zip, String sourceDir, String sourceZip) {
        this.overwriteCheckBox.setSelection(overwrite);
        this.taskListCheckBox.setSelection(importTaskList);
        this.taskActivationHistoryCheckBox.setSelection(importActivationHistory);
        this.taskContextsCheckBox.setSelection(importTaskContexts);
        this.sourceZipText.setText(sourceZip);
        this.importViaZipButton.setSelection(zip);
    }
}

