/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleTaskActivationAction;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractTaskEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.NewTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.RepositoryTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorBusyIndicator;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.IBusyEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.util.SelectionProviderAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TaskEditor
extends SharedHeaderFormEditor {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editors.task";
    private ToggleTaskActivationAction activateAction;
    @Deprecated
    private IEditorPart contentOutlineProvider = null;
    private EditorBusyIndicator editorBusyIndicator;
    private MenuManager menuManager;
    private IHyperlinkListener messageHyperLinkListener;
    private ITask task;
    private TaskEditorInput taskEditorInput;
    private TaskDragSourceListener titleDragSourceListener;

    @Deprecated
    private void addPage(AbstractTaskEditorFactory factory) {
        IEditorInput editorInput = this.taskEditorInput != null && this.taskEditorInput.getTask() == null ? new RepositoryTaskEditorInput(this.taskEditorInput.getTaskRepository(), this.taskEditorInput.getTask().getTaskId(), "") : this.getEditorInput();
        if (factory.canCreateEditorFor(this.task) || factory.canCreateEditorFor(editorInput)) {
            try {
                IEditorInput input;
                IEditorPart editor = factory.createEditor(this, editorInput);
                IEditorInput iEditorInput = input = this.task != null ? factory.createEditorInput(this.task) : editorInput;
                if (editor != null && input != null) {
                    FormPage taskEditor = (FormPage)editor;
                    editor.init(this.getEditorSite(), input);
                    int index = this.addPage((IFormPage)taskEditor);
                    if (input.getImageDescriptor() != null) {
                        this.setPageImage(index, CommonImages.getImage((ImageDescriptor)input.getImageDescriptor()));
                    }
                    if (editor instanceof AbstractRepositoryTaskEditor) {
                        ((AbstractRepositoryTaskEditor)editor).setParentEditor(this);
                        if (editorInput instanceof RepositoryTaskEditorInput) {
                            RepositoryTaskEditorInput existingInput = (RepositoryTaskEditorInput)editorInput;
                            this.setPartName(existingInput.getName());
                        } else if (editorInput instanceof NewTaskEditorInput) {
                            String label = ((NewTaskEditorInput)editorInput).getName();
                            this.setPartName(label);
                        }
                        this.setPageText(index, factory.getTitle());
                        this.setActivePage(index);
                    }
                }
                if (factory.providesOutline()) {
                    this.contentOutlineProvider = editor;
                }
            }
            catch (Exception e) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create editor via factory: " + factory, (Throwable)e));
            }
        }
    }

    protected void addPages() {
        this.initialize();
        if (this.taskEditorInput != null) {
            HashSet conflictingIds = new HashSet();
            ArrayList<AbstractTaskEditorPageFactory> pageFactories = new ArrayList<AbstractTaskEditorPageFactory>();
            AbstractTaskEditorPageFactory[] abstractTaskEditorPageFactoryArray = TasksUiPlugin.getDefault().getTaskEditorPageFactories();
            int n = abstractTaskEditorPageFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTaskEditorPageFactory pageFactory = abstractTaskEditorPageFactoryArray[n2];
                if (pageFactory.canCreatePageFor(this.getTaskEditorInput())) {
                    pageFactories.add(pageFactory);
                    String[] ids = pageFactory.getConflictingIds(this.getTaskEditorInput());
                    if (ids != null) {
                        conflictingIds.addAll(Arrays.asList(ids));
                    }
                }
                ++n2;
            }
            Iterator it = pageFactories.iterator();
            while (it.hasNext()) {
                if (!conflictingIds.contains(((AbstractTaskEditorPageFactory)it.next()).getId())) continue;
                it.remove();
            }
            Collections.sort(pageFactories, new Comparator<AbstractTaskEditorPageFactory>(){

                @Override
                public int compare(AbstractTaskEditorPageFactory o1, AbstractTaskEditorPageFactory o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            for (AbstractTaskEditorPageFactory factory : pageFactories) {
                try {
                    IFormPage page = factory.createPage(this);
                    int index = this.addPage(page);
                    this.setPageImage(index, factory.getPageImage());
                    this.setPageText(index, factory.getPageText());
                    if (factory.getPriority() == 30) {
                        this.setActivePage(index);
                    }
                    if (!(page instanceof ISelectionProvider)) continue;
                    ((ISelectionProvider)page).addSelectionChangedListener((ISelectionChangedListener)this.getActionBarContributor());
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create editor via factory: " + factory, (Throwable)e));
                }
            }
        }
        ArrayList<AbstractTaskEditorFactory> factories = new ArrayList<AbstractTaskEditorFactory>(TasksUiPlugin.getDefault().getTaskEditorFactories());
        Collections.sort(factories, new Comparator<AbstractTaskEditorFactory>(){

            @Override
            public int compare(AbstractTaskEditorFactory o1, AbstractTaskEditorFactory o2) {
                return o1.getTabOrderPriority() - o2.getTabOrderPriority();
            }
        });
        for (AbstractTaskEditorFactory factory : factories) {
            this.addPage(factory);
        }
        this.updateTitleImage();
        this.updateHeaderToolBar();
    }

    private void initialize() {
        this.editorBusyIndicator = new EditorBusyIndicator(new IBusyEditor(){

            public Image getTitleImage() {
                return TaskEditor.this.getTitleImage();
            }

            public void setTitleImage(Image image) {
                TaskEditor.this.setTitleImage(image);
            }
        });
        this.menuManager = new MenuManager();
        this.configureContextMenuManager(this.menuManager);
        Menu menu = this.menuManager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(menu);
        this.getEditorSite().registerContextMenu(this.menuManager, this.getEditorSite().getSelectionProvider(), false);
    }

    @Deprecated
    public void configureContextMenuManager(MenuManager manager) {
        if (manager == null) {
            return;
        }
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
    }

    @Deprecated
    protected void contextMenuAboutToShow(IMenuManager manager) {
        TaskEditorActionContributor contributor = this.getActionBarContributor();
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(TasksUiPlugin.getDefault().getFormColors(display));
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
        this.updateHeader();
        this.installTitleDrag(this.getHeaderForm().getForm().getForm());
    }

    public void dispose() {
        if (this.editorBusyIndicator != null) {
            this.editorBusyIndicator.stop();
        }
        if (this.activateAction != null) {
            this.activateAction.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                page.doSave(monitor);
            }
            ++n2;
        }
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    private TaskEditorActionContributor getActionBarContributor() {
        return (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class adapter) {
        if (this.contentOutlineProvider != null) {
            return this.contentOutlineProvider.getAdapter(adapter);
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            IFormPage[] pages;
            IFormPage[] iFormPageArray = pages = this.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                Object outlinePage = page.getAdapter(adapter);
                if (outlinePage != null) {
                    return outlinePage;
                }
                ++n2;
            }
        }
        return super.getAdapter(adapter);
    }

    public Menu getMenu() {
        return this.getContainer().getMenu();
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    formPages.add(page);
                }
                ++i;
            }
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    @Deprecated
    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    @Deprecated
    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TaskEditorInput getTaskEditorInput() {
        return this.taskEditorInput;
    }

    @Deprecated
    public Form getTopForm() {
        return this.getHeaderForm().getForm().getForm();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof TaskEditorInput) {
            this.taskEditorInput = (TaskEditorInput)input;
            this.task = this.taskEditorInput.getTask();
        }
        this.setPartName(input.getName());
    }

    private void installTitleDrag(Form form) {
        if (this.task == null) {
            return;
        }
        if (this.titleDragSourceListener == null) {
            Transfer[] transferTypes = this.task == null ? new Transfer[]{TextTransfer.getInstance()} : new Transfer[]{TaskTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance()};
            this.titleDragSourceListener = new TaskDragSourceListener(new SelectionProviderAdapter(){

                public ISelection getSelection() {
                    return new StructuredSelection((Object)TaskEditor.this.task);
                }
            });
            form.addTitleDragSupport(6, transferTypes, (DragSourceListener)this.titleDragSourceListener);
        }
    }

    public boolean isDirty() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Deprecated
    public void markDirty() {
        this.firePropertyChange(257);
    }

    public void refreshPages() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof AbstractTaskEditorPage) {
                ((AbstractTaskEditorPage)page).refreshFormContent();
            } else if (page instanceof AbstractRepositoryTaskEditor) {
                AbstractRepositoryTaskEditor editor = (AbstractRepositoryTaskEditor)page;
                editor.refreshEditor();
            }
            ++n2;
        }
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Deprecated
    public void setFocusOfActivePage() {
        IFormPage page;
        if (this.getActivePage() > -1 && (page = this.getPages()[this.getActivePage()]) != null) {
            page.setFocus();
        }
    }

    public void setMessage(String message, int type) {
        this.setMessage(message, type, null);
    }

    public void setMessage(String message, int type, IHyperlinkListener listener) {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            Form form = this.getHeaderForm().getForm().getForm();
            form.setMessage(message, type);
            if (this.messageHyperLinkListener != null) {
                form.removeMessageHyperlinkListener(this.messageHyperLinkListener);
            }
            if (listener != null) {
                form.addMessageHyperlinkListener(listener);
            }
            this.messageHyperLinkListener = listener;
        }
    }

    public void setStatus(String message, final String title, final IStatus status) {
        this.setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                TasksUiInternal.displayStatus(title, status);
            }
        });
    }

    public void showBusy(boolean busy) {
        Form form;
        if (this.editorBusyIndicator != null) {
            if (busy) {
                if (TasksUiInternal.isAnimationsEnabled()) {
                    this.editorBusyIndicator.start();
                }
            } else {
                this.editorBusyIndicator.stop();
            }
        }
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed() && (form = this.getHeaderForm().getForm().getForm()) != null && !form.isDisposed()) {
            ToolBar control;
            IToolBarManager toolBarManager = form.getToolBarManager();
            if (toolBarManager instanceof ToolBarManager && (control = ((ToolBarManager)toolBarManager).getControl()) != null) {
                control.setEnabled(!busy);
            }
            EditorUtil.setEnabledState(form.getBody(), !busy);
            IFormPage[] iFormPageArray = this.getPages();
            int n = iFormPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                if (page instanceof WorkbenchPart) {
                    WorkbenchPart part = (WorkbenchPart)page;
                    part.showBusy(busy);
                }
                ++n2;
            }
        }
    }

    private void updateHeader() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput) {
            this.updateHeaderImage(this.task.getConnectorKind());
            this.updateHeaderLabel(this.task);
        } else if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskData taskData = ((RepositoryTaskEditorInput)input).getTaskData();
            if (this.task != null) {
                this.updateHeaderImage(this.task.getConnectorKind());
                this.updateHeaderLabel(this.task);
            } else if (taskData != null) {
                this.updateHeaderImage(taskData.getConnectorKind());
                this.updateHeaderLabel(taskData);
            }
        }
        this.installTitleDrag(this.getHeaderForm().getForm().getForm());
    }

    public void updateHeaderToolBar() {
        Form form = this.getHeaderForm().getForm().getForm();
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.update(true);
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormPage taskEditorPage;
            IFormPage page = iFormPageArray[n2];
            if (page instanceof AbstractTaskEditorPage) {
                taskEditorPage = (AbstractTaskEditorPage)page;
                taskEditorPage.fillToolBar(toolBarManager);
            } else if (page instanceof AbstractRepositoryTaskEditor) {
                taskEditorPage = (AbstractRepositoryTaskEditor)page;
                taskEditorPage.fillToolBar(toolBarManager);
            }
            ++n2;
        }
        if (this.task != null) {
            if (this.activateAction == null) {
                this.activateAction = new ToggleTaskActivationAction(this.task);
            }
            toolBarManager.add((IContributionItem)new Separator("activation"));
            toolBarManager.add((IAction)this.activateAction);
        }
        toolBarManager.update(true);
    }

    private void updateHeaderImage(String connectorKind) {
        if ("local".equals(connectorKind)) {
            this.getHeaderForm().getForm().setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        } else {
            ImageDescriptor overlay = TasksUiPlugin.getDefault().getOverlayIcon(connectorKind);
            Image image = CommonImages.getImageWithOverlay((ImageDescriptor)TasksUiImages.REPOSITORY, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
            this.getHeaderForm().getForm().setImage(image);
        }
    }

    private void updateHeaderLabel(ITask task) {
        if (task instanceof LocalTask) {
            this.getHeaderForm().getForm().setText("Task: " + task.getSummary());
        } else {
            String idLabel;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
            String kindLabel = "";
            if (connectorUi != null) {
                kindLabel = connectorUi.getTaskKindLabel(task);
            }
            if ((idLabel = task.getTaskKey()) != null) {
                this.getHeaderForm().getForm().setText(String.valueOf(kindLabel) + " " + idLabel);
            } else {
                this.getHeaderForm().getForm().setText(kindLabel);
            }
        }
    }

    @Deprecated
    private void updateHeaderLabel(RepositoryTaskData taskData) {
        String kindLabel = taskData.getTaskKind();
        String idLabel = taskData.getTaskKey();
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskData.getConnectorKind());
        if (connectorUi != null && this.task != null) {
            kindLabel = connectorUi.getTaskKindLabel(this.task);
        }
        if (taskData.isNew()) {
            kindLabel = "New " + kindLabel;
            idLabel = "";
        }
        if (this.getHeaderForm().getForm() != null) {
            if (idLabel != null) {
                this.getHeaderForm().getForm().setText(String.valueOf(kindLabel) + " " + idLabel);
            } else {
                this.getHeaderForm().getForm().setText(kindLabel);
            }
        }
    }

    @Deprecated
    public void updateTitle(String name) {
        this.setPartName(name);
        this.setTitleToolTip(name);
        this.updateHeader();
    }

    private void updateTitleImage() {
        if (this.task != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.task.getConnectorKind());
            if (connectorUi != null) {
                ImageDescriptor overlayDescriptor = connectorUi.getTaskKindOverlay(this.task);
                this.setTitleImage(CommonImages.getCompositeTaskImage((ImageDescriptor)TasksUiImages.TASK, (ImageDescriptor)overlayDescriptor, (boolean)false));
            } else {
                this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
            }
        } else if (this.getEditorInput() instanceof AbstractRepositoryTaskEditorInput) {
            this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_REMOTE));
        } else {
            this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        }
    }
}

