/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryQueryWizard;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractRepositoryQueryPage
extends WizardPage
implements ITaskSearchPage {
    private static final String TITLE = "Enter query parameters";
    private static final String DESCRIPTION = "If attributes are blank or stale press the Update button.";
    private ITaskSearchPageContainer searchContainer;
    private final TaskRepository taskRepository;
    private final IRepositoryQuery query;

    public AbstractRepositoryQueryPage(String title, TaskRepository taskRepository, IRepositoryQuery query) {
        super(title);
        Assert.isNotNull((Object)taskRepository);
        this.taskRepository = taskRepository;
        this.query = query;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setPageComplete(false);
    }

    public AbstractRepositoryQueryPage(String title, TaskRepository taskRepository) {
        this(title, taskRepository, null);
    }

    public IRepositoryQuery getQuery() {
        return this.query;
    }

    public abstract String getQueryTitle();

    public boolean isPageComplete() {
        String queryTitle = this.getQueryTitle();
        if (queryTitle == null || queryTitle.equals("")) {
            this.setErrorMessage("Please specify a title for the query.");
            return false;
        }
        Set queries = TasksUiInternal.getTaskList().getQueries();
        Set categories = TasksUiInternal.getTaskList().getCategories();
        String oldSummary = null;
        if (this.query != null) {
            oldSummary = this.query.getSummary();
        } else if (this.getWizard() instanceof AbstractRepositoryQueryWizard) {
            oldSummary = ((AbstractRepositoryQueryWizard)this.getWizard()).getQuerySummary();
        }
        if (oldSummary != null && queryTitle.equals(oldSummary)) {
            this.setErrorMessage(null);
            return true;
        }
        for (AbstractTaskCategory category : categories) {
            if (!queryTitle.equals(category.getSummary())) continue;
            this.setErrorMessage("A category with this name already exists, please choose another name.");
            return false;
        }
        for (RepositoryQuery repositoryQuery : queries) {
            if (this.query != null && this.query.equals(repositoryQuery) || !queryTitle.equals(repositoryQuery.getSummary())) continue;
            this.setErrorMessage("A query with this name already exists, please choose another name.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IRepositoryQuery createQuery() {
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.getTaskRepository());
        this.applyTo(query);
        return query;
    }

    public abstract void applyTo(IRepositoryQuery var1);

    public void saveState() {
    }

    public void setContainer(ITaskSearchPageContainer container) {
        this.searchContainer = container;
    }

    public boolean inSearchContainer() {
        return this.searchContainer != null;
    }

    public boolean performSearch() {
        NewSearchUI.activateSearchResultView();
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind());
        if (connector != null) {
            try {
                SearchHitCollector collector = new SearchHitCollector(TasksUiInternal.getTaskList(), this.taskRepository, this.createQuery());
                NewSearchUI.runQueryInBackground((ISearchQuery)collector);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                SearchHitCollector collector = new SearchHitCollector(TasksUiInternal.getTaskList(), this.taskRepository, this.getQuery());
                NewSearchUI.runQueryInBackground((ISearchQuery)collector);
            }
        }
        return true;
    }

    public void setControlsEnabled(boolean enabled) {
        this.setControlsEnabled(this.getControl(), enabled);
    }

    private void setControlsEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                childControl.setEnabled(enabled);
                this.setControlsEnabled(childControl, enabled);
                ++n2;
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public ITaskSearchPageContainer getSearchContainer() {
        return this.searchContainer;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }
}

