/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.caching;

import org.eclipse.jpt.eclipselink.core.internal.context.caching.Caching;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.util.LabeledControl;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheSizeComposite
extends Pane<Caching> {
    public DefaultCacheSizeComposite(Pane<Caching> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private WritablePropertyValueModel<Integer> buildCacheSizeHolder() {
        return new PropertyAspectAdapter<Caching, Integer>(this.getSubjectHolder(), new String[]{"cacheSizeDefaultProperty"}){

            protected Integer buildValue_() {
                Integer value = ((Caching)this.subject).getCacheSizeDefault();
                if (value == null) {
                    value = -1;
                }
                return value;
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Caching)this.subject).setCacheSizeDefault(value);
            }
        };
    }

    private PropertyValueModel<Integer> buildDefaultCacheSizeHolder() {
        return new PropertyAspectAdapter<Caching, Integer>(this.getSubjectHolder(), new String[]{""}){

            protected Integer buildValue_() {
                return ((Caching)this.subject).getDefaultCacheSizeDefault();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control addDefaultCacheSizeLabel(Composite container) {
        Label label = this.addLabel(container, EclipseLinkUiMessages.DefaultWithoutValue);
        new LabeledControlUpdater((LabeledControl)new LabeledLabel(label), this.buildDefaultCacheSizeLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultCacheSizeLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultCacheSizeHolder()){

            protected String transform(Integer value) {
                if (value != null) {
                    return NLS.bind((String)EclipseLinkUiMessages.DefaultWithValue, (Object)value);
                }
                return "";
            }
        };
    }

    protected void initializeLayout(Composite container) {
        Spinner spinner = this.addLabeledSpinner(container, EclipseLinkUiMessages.DefaultCacheSizeComposite_defaultCacheSize, this.buildCacheSizeHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultCacheSizeLabel(container), null);
        this.updateGridData(container, spinner);
    }

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

